<?php
/**
* @package XenCentral Ad Server
* @author Skydevelop EU
* @copyright Drnoyan & Nalyan LDA, Portugal, EU
* @license http://www.dnf.pt/eula.html
* @link http://www.skydevelop.com
* @revision 97
* @version 2.0.0 beta 3 rev. 3
*/


class XenCentral_AdServer_ControllerHelper_Delivery extends XenForo_ControllerHelper_Abstract
{
    public function getDeliveryFrameworkParams()
    {
        $params = array(
                'resourceLoaderPath' => XenForo_Application::getInstance()->getRootDir() . '/js/XenCentral/AdServer/resource_loader.js',
                'resources' => array(
                        'jQuerySource' => $this->_getJsUrl('jquery/jquery-' . XenForo_Application::$jQueryVersion . '.min.js'),
                        'scripts' => array(),
                        'links' => array()
                )
        );

        foreach (array(
                         $this->_getJsUrl('XenCentral/AdServer/delivery_core.js'),
                 ) AS $script) {
            $params['resources']['scripts'][md5($script)] = $script;
        }

        $cssTemplates=$this->_getCssTemplates();

        foreach (array() AS $link) {
            $params['resources']['links'][md5($link)] = $link;
        }
        
        $params['cssTemplates']=$cssTemplates;

        return $params;
    }

    protected function _getCssTemplates()
    {
        return array(
            'xcas_delivery_css'
        );
    }

    protected function _getJsUrl($relativeUrl)
    {
        $jsUrl = XenForo_Application::$javaScriptUrl . '/' . $relativeUrl;
        if (!parse_url($jsUrl, PHP_URL_HOST)) {
            $jsUrl = XenForo_Application::getOptions()->get('boardUrl') . '/js/' . $relativeUrl;
        }

        return $jsUrl;
    }
}