<?php

/**
 * Installer for Trophy Categories by Waindigo.
 */
class Waindigo_Trophies_Install_Controller extends Waindigo_Install
{

    protected $_resourceManagerUrl = 'http://xenforo.com/community/resources/trophies-by-waindigo.2220/';

    /**
     * Gets the tables (with fields) to be created for this add-on. See parent for explanation.
     *
     * @return array Format: [table name] => fields
     */
    protected function _getTables()
    {
        return array(
            'xf_trophy_category' => array(
                'trophy_category_id' => 'INT(10) UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY', /* END 'trophy_category_id' */
                'title' => 'VARCHAR(255) NOT NULL', /* END 'title' */
                'parent_category_id' => 'INT(10) UNSIGNED NOT NULL DEFAULT 0', /* END 'parent_category_id' */
                'display_order' => 'INT(3) UNSIGNED NOT NULL DEFAULT 1', /* END 'display_order' */
            ), /* END 'xf_trophy_category' */
            'xf_trophy_combination' => array(
                'trophy_combination_id' => 'int(10) unsigned NOT NULL AUTO_INCREMENT PRIMARY KEY', /* END 'trophy_combination_id' */
                'trophy_ids' => 'MEDIUMTEXT', /* END 'trophy_ids' */
                'cache_value' => 'MEDIUMTEXT', /* END 'cache_value' */
            ), /* END 'xf_trophy_combination' */
        );
    } /* END _getTables */

    protected function _getTableChanges()
    {
        return array(
            'xf_trophy' => array(
                'trophy_category_id' => 'INT(10) UNSIGNED NOT NULL DEFAULT 0', /* END 'trophy_category_id' */
                'icon_url' => 'VARCHAR(255) NOT NULL DEFAULT \'\'', /* END 'icon_url' */
                ), /* END 'xf_trophy' */
            'xf_user_profile' => array(
                'trophy_combination_id' => 'INT(10) NOT NULL DEFAULT 0', /* END 'trophy_combination_id' */
            ), /* END 'xf_user_profile' */
            'xf_user_option' => array(
                'trophy_category_ids' => 'VARCHAR(255) NOT NULL DEFAULT \'\'', /* END 'trophy_category_ids' */
            ), /* END 'xf_user_option' */
        );
    } /* END _getTableChanges */
}