<?php

class Waindigo_ResMans_Route_ResourceManagers implements XenForo_Route_Interface
{

    const SIMPLE_CACHE_KEY = 'waindigo_resMans_resourceManagers';

    /**
     * Attempts to match the routing path.
     * See {@link XenForo_Route_Interface} for further details.
     *
     * @param string Routing path
     * @param Zend_Controller_Request_Http Request object
     * @param XenForo_Router Routing object
     *
     * @return false XenForo_RouteMatch
     */
    public function match($routePath, Zend_Controller_Request_Http $request, XenForo_Router $router)
    {
        if (!XenForo_Application::getSimpleCacheData(self::SIMPLE_CACHE_KEY)) {
            return false;
        }

        $resourceManagers = XenForo_Application::getSimpleCacheData(self::SIMPLE_CACHE_KEY);

        $parts = explode('/', $routePath, 2);
        if (count($parts) > 1) {
            list ($prefix, $extra) = $parts;
        } else {
            $prefix = $parts[0];
            $extra = '';
        }
        if ($prefix === '') {
            return false;
        }

        if (preg_match('#[^a-zA-Z0-9_-]#', $prefix)) {
            return false;
        }

        foreach ($resourceManagers as $resourceManagerId => $resourceManager) {
            if ($resourceManager['original_prefix'] == $prefix) {
                Waindigo_ResMans_ResourceManager::getInstance()->setup($resourceManagerId);

                $match = $router->getRouteMatch();
                $routePath = 'resources' . ($extra ? '/' . $extra : '');
                $match->setModifiedRoutePath($routePath);
                return $match;
            }
        }
    } /* END match */
}