<?php

/**
 * Resource Manager Class
 */
class Waindigo_ResMans_ResourceManager implements ArrayAccess
{

    const SIMPLE_CACHE_KEY = 'waindigo_resMans_resourceManagers';

    /**
     * Instance manager.
     *
     * @var Waindigo_ResMans_ResourceManager
     */
    protected static $_instance;

    protected static $_altOriginalPrefix;

    /**
     * Array of sub-domain info.
     *
     * @var array
     */
    protected $_resourceManager = array();

    /**
     * Protected constructor.
     * Use {@link getInstance()} instead.
     */
    protected function __construct()
    {
    } /* END __construct */

    /**
     * Gets the resource manager info.
     *
     * @return Waindigo_ResMans_ResourceManager
     */
    public static final function getInstance()
    {
        if (!self::$_instance) {
            self::setup(0); // setup sets the instance
        }

        return self::$_instance;
    } /* END getInstance */

    /**
     * Determines if we have a sub-domain instance setup.
     *
     * @return boolean
     */
    public static function hasInstance()
    {
        return (self::$_instance ? true : false);
    } /* END hasInstance */

    /**
     * Gets the sub-domain info in array format (for areas that require actual
     * arrays).
     *
     * @return array
     */
    public function toArray()
    {
        return $this->_resourceManager;
    } /* END toArray */

    /**
     * Setup the resource manager singleton.
     *
     * @return Waindigo_ResourceManager
     */
    public static function setup($resourceManagerId)
    {
        $object = new self();

        $resourceManagers = XenForo_Application::getSimpleCacheData(self::SIMPLE_CACHE_KEY);

        if (isset($resourceManagers[$resourceManagerId])) {
            $object->_resourceManager = $resourceManagers[$resourceManagerId];
        }

        self::$_instance = $object;

        return self::$_instance;
    } /* END setup */

    public static function getAlternativeOriginalPrefix()
    {
        return self::$_altOriginalPrefix;
    } /* END getAlternativeOriginalPrefix */

    public static function setAlternativeOriginalPrefix($prefix)
    {
        self::$_altOriginalPrefix = $prefix;
    } /* END setAlternativeOriginalPrefix */

    /**
     * OO approach to getting a value from the sub-domain.
     * Good if you want a single value in one line.
     *
     * @param string $name
     *
     * @return mixed False if the value can't be found
     */
    public function get($name)
    {
        if (array_key_exists($name, $this->_resourceManager)) {
            return $this->_resourceManager[$name];
        } else {
            return false;
        }
    } /* END get */

    /**
     * For ArrayAccess.
     *
     * @param string $offset
     */
    public function offsetExists($offset)
    {
        return isset($this->_resourceManager[$offset]);
    } /* END offsetExists */

    /**
     * For ArrayAccess.
     *
     * @param string $offset
     */
    public function offsetGet($offset)
    {
        return $this->_resourceManager[$offset];
    } /* END offsetGet */

    /**
     * For ArrayAccess.
     *
     * @param string $offset
     * @param mixed $value
     */
    public function offsetSet($offset, $value)
    {
        $this->_resourceManager[$offset] = $value;
    } /* END offsetSet */

    /**
     * For ArrayAccess.
     *
     * @param string $offset
     */
    public function offsetUnset($offset)
    {
        unset($this->_resourceManager[$offset]);
    } /* END offsetUnset */

    /**
     * Magic method for array access
     */
    public function __get($name)
    {
        return $this->get($name);
    } /* END __get */
}
