<?php

class Waindigo_ResMans_Listener_NavigationTabs extends Waindigo_Listener_NavigationTabs
{

    const SIMPLE_CACHE_KEY = 'waindigo_resMans_resourceManagers';

    protected $_multipleLanguages = false;

    /**
     * Gets the navigation tabs for this add-on.
     * See parent for explanation.
     *
     * @return array
     */
    protected function _getNavigationTabs()
    {
        $resourceManagers = XenForo_Application::getSimpleCacheData(self::SIMPLE_CACHE_KEY);

        if (!$resourceManagers) {
            return array();
        }

        $addOns = XenForo_Application::get('addOns');
        if (!isset($addOns['XenResource'])) {
            return array();
        }

        $extraTabs = array();

        foreach ($resourceManagers as $resourceManager) {
            if ($resourceManager['language_id']) {
                $this->_multipleLanguages = true;
            }
            if (XenForo_Visitor::getInstance()->hasPermission('resource', 'view')) {
                if (isset($resourceManager['allowed_user_group_ids'])) {
                    /* @var $resourceManagerModel Waindigo_ResMans_Model_ResourceManager */
                    $resourceManagerModel = XenForo_Model::create('Waindigo_ResMans_Model_ResourceManager');

                    if ($resourceManagerModel->verifyResourceManagerIsUsable($resourceManager)) {
                        $extraTabs[$resourceManager['original_prefix']] = array(
                            'title' => $resourceManager['title'],
                            'href' => XenForo_Link::buildPublicLink('full:' . $resourceManager['original_prefix'],
                                array(
                                    'forcePrefix' => true
                                )),
                            'position' => 'middle',
                            'linksTemplate' => 'resources_tab_links',
                            'resourceManager' => $resourceManager
                        );
                    }
                }
            }
        }

        return $extraTabs;
    } /* END _getNavigationTabs */

    public function run()
    {
        parent::run();

        $xenOptions = XenForo_Application::getOptions();

        if (isset($this->_extraTabs['resources'])) {
            if ($xenOptions->waindigo_resMans_showResourcesTab) {
                if ($this->_multipleLanguages) {
                    $languages = XenForo_Application::get('languages');

                    $languageId = $xenOptions->defaultLanguageId;

                    $language = $languages[$languageId];

                    $phraseCache = $language['phrase_cache'];
                    $this->_extraTabs['resources']['title'] = $phraseCache['resources'];
                }

                $this->_extraTabs['resources']['href'] = XenForo_Link::buildPublicLink('resources',
                    array(
                        'forcePrefix' => true
                    ));
                $this->_extraTabs['resources']['showActiveAuthorLink'] = true;
            } else {
                unset($this->_extraTabs['resources']);
            }
        }

        return $this->_extraTabs;
    } /* END run */

    public static function navigationTabs(array &$extraTabs, $selectedTabId)
    {
        $navigationTabsModel = new Waindigo_ResMans_Listener_NavigationTabs($extraTabs, $selectedTabId);
        $extraTabs = $navigationTabsModel->run();
    } /* END navigationTabs */
}