<?php

class Waindigo_ResMans_Listener_LoadClass extends Waindigo_Listener_LoadClass
{

    protected function _getExtendedClasses()
    {
        return array(
            'Waindigo_ResMans' => array(
                'route_prefix' => array(
                    'XenResource_Route_Prefix_Resources'
                ), /* END 'route_prefix' */
                'model' => array(
                    'XenResource_Model_Resource',
                    'XenResource_Model_Category',
                    'XenForo_Model_User'
                ), /* END 'model' */
                'controller' => array(
                    'XenResource_ControllerPublic_Resource',
                    'XenResource_ControllerAdmin_Category'
                ), /* END 'controller' */
                'datawriter' => array(
                    'XenResource_DataWriter_Category'
                ), /* END 'datawriter' */
                'search_data' => array(
                    'XenResource_Search_DataHandler_Update'
                ), /* END 'search_data' */
                'listener_waindigo' => array(
                    'Waindigo_RssFeeds_Listener_ContainerPublicParams'
                ), /* END 'listener_waindigo' */
            ), /* END 'Waindigo_ResMans' */
        );
    } /* END _getExtendedClasses */

    public static function loadClassRoutePrefix($class, array &$extend)
    {
        $extend = self::createAndRun('Waindigo_ResMans_Listener_LoadClass', $class, $extend, 'route_prefix');
    } /* END loadClassRoutePrefix */

    public static function loadClassModel($class, array &$extend)
    {
        $extend = self::createAndRun('Waindigo_ResMans_Listener_LoadClass', $class, $extend, 'model');
    } /* END loadClassModel */

    public static function loadClassController($class, array &$extend)
    {
        $extend = self::createAndRun('Waindigo_ResMans_Listener_LoadClass', $class, $extend, 'controller');
    } /* END loadClassController */

    public static function loadClassDataWriter($class, array &$extend)
    {
        $extend = self::createAndRun('Waindigo_ResMans_Listener_LoadClass', $class, $extend, 'datawriter');
    } /* END loadClassDataWriter */

    public static function loadClassSearchData($class, array &$extend)
    {
        $extend = self::createAndRun('Waindigo_ResMans_Listener_LoadClass', $class, $extend, 'search_data');
    } /* END loadClassSearchData */

    public static function loadClassListenerWaindigo($class, array &$extend)
    {
        $extend = self::createAndRun('Waindigo_ResMans_Listener_LoadClass', $class, $extend, 'listener_waindigo');
    } /* END loadClassListenerWaindigo */
}