<?php

class Waindigo_ResMans_Listener_InitDependencies extends Waindigo_Listener_InitDependencies
{

    const SIMPLE_CACHE_KEY = 'waindigo_resMans_resourceManagers';

    public function run()
    {
        if (isset(self::$_data['routesPublic']['resources'])) {
            self::$_data['routesPublic']['resources']['build_link'] = 'all';

            $resourceManagers = XenForo_Application::getSimpleCacheData(self::SIMPLE_CACHE_KEY);

            if ($resourceManagers) {
                foreach ($resourceManagers as $resourceManager) {
                    if (!isset(self::$_data['routesPublic'][$resourceManager['original_prefix']])) {
                        self::$_data['routesPublic'][$resourceManager['original_prefix']] = self::$_data['routesPublic']['resources'];
                    }
                }
            }

            XenForo_Link::setHandlerInfoForGroup('public', self::$_data['routesPublic']);
        }

        XenForo_Template_Helper_Core::$helperCallbacks['resourcelink'] = array(
            'Waindigo_ResMans_Template_Helper',
            'link'
        );

        return parent::run();
    } /* END run */

    public static function initDependencies(XenForo_Dependencies_Abstract $dependencies, array $data)
    {
        $initDependencies = new Waindigo_ResMans_Listener_InitDependencies($dependencies, $data);
        $initDependencies->run();
    } /* END initDependencies */
}