<?php

class Waindigo_ResMans_Listener_ControllerPreDispatch extends Waindigo_Listener_ControllerPreDispatch
{

    const SIMPLE_CACHE_KEY = 'waindigo_resMans_resourceManagers';

    public static function controllerPreDispatch(XenForo_Controller $controller, $action)
    {
        $controllerPreDispatch = new Waindigo_ResMans_Listener_ControllerPreDispatch($controller, $action);
        $controllerPreDispatch->run();

        $visitor = XenForo_Visitor::getInstance();

        if (Waindigo_ResMans_ResourceManager::hasInstance()) {
            $resourceManager = Waindigo_ResMans_ResourceManager::getInstance();

            if (!empty($resourceManager['language_id'])) {
                $visitor->setVisitorLanguage($resourceManager['language_id']);
            }
            if (!empty($resourceManager['style_id'])) {
                $controller->setViewStateChange('styleId', $resourceManager['style_id']);
            }
        }
    } /* END controllerPreDispatch */
}