<?php

/**
 * Installer for Resource Managers by Waindigo.
 */
class Waindigo_ResMans_Install_Controller extends Waindigo_Install
{

    const SIMPLE_CACHE_KEY = 'waindigo_resMans_resourceManagers';

    protected $_resourceManagerUrl = 'http://xenforo.com/community/resources/resource-managers-by-waindigo.2744/';

    protected function _getPrerequisites()
    {
        return array(
            'XenResource' => '1010000'
        );
    } /* END _getPrerequisites */

    /**
     * Gets the tables (with fields) to be created for this add-on.
     * See parent for explanation.
     *
     * @return array Format: [table name] => fields
     */
    protected function _getTables()
    {
        return array(
            'xf_resource_manager_waindigo' => array(
                'resource_manager_id' => 'INT(10) UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY', /* END 'resource_manager_id' */
                'title' => 'VARCHAR(255) NOT NULL', /* END 'title' */
                'original_prefix' => 'VARCHAR(25) NOT NULL DEFAULT \'\'', /* END 'original_prefix' */
                'language_id' => 'INT(10) UNSIGNED NOT NULL DEFAULT 0', /* END 'language_id' */
                'style_id' => 'INT(10) UNSIGNED NOT NULL DEFAULT 0', /* END 'style_id' */
                'phrase_cache' => 'MEDIUMBLOB NULL', /* END 'phrase_cache' */
                'hide_tabs' => 'BLOB NULL', /* END 'hide_tabs' */
                'default_tab' => 'VARCHAR(25) NOT NULL DEFAULT \'last_update\'', /* END 'default_tab' */
                'allowed_user_group_ids' => 'BLOB NULL', /* END 'allowed_user_group_ids' */
            ), /* END 'xf_resource_manager_waindigo' */
            'xf_resource_manager_category_waindigo' => array(
                'resource_manager_id' => 'INT(10) UNSIGNED NOT NULL', /* END 'resource_manager_id' */
                'resource_category_id' => 'INT(10) UNSIGNED NOT NULL', /* END 'resource_category_id' */
            ), /* END 'xf_resource_manager_category_waindigo' */
        );
    } /* END _getTables */

    protected function _getTableChanges()
    {
        return array(
            'xf_resource_category' => array(
                'resource_manager_id_waindigo' => 'INT(10) UNSIGNED NOT NULL DEFAULT 0', /* END 'default_resource_manager_id_waindigo' */
            ), /* END 'xf_resource_category' */
        );
    } /* END _getTableChanges */

    protected function _getPrimaryKeys()
    {
        return array(
            'xf_resource_manager_category_waindigo' => array(
                'resource_manager_id',
                'resource_category_id'
            ), /* END 'xf_resource_manager_category_waindigo' */
        );
    } /* END _getPrimaryKeys */

    protected function _getKeys()
    {
        return array(
            'xf_resource_manager_category_waindigo' => array(
                'resource_category_id' => array(
                    'resource_category_id'
                ), /* END 'resource_category_id' */
            ), /* END 'xf_resource_manager_category_waindigo' */
        );
    } /* END _getKeys */

    protected function _postUninstall()
    {
        XenForo_Application::setSimpleCacheData(self::SIMPLE_CACHE_KEY, false);
    } /* END _postUninstall */
}