<?php

/**
 *
 * @see XenResource_Search_DataHandler_Update
 */
class Waindigo_ResMans_Extend_XenResource_Search_DataHandler_Update extends XFCP_Waindigo_ResMans_Extend_XenResource_Search_DataHandler_Update
{

    const SIMPLE_CACHE_KEY = 'waindigo_resMans_resourceManagers';

    /**
     * Get type-specific constraints from input.
     *
     * @param XenForo_Input $input
     *
     * @return array
     */
    public function getTypeConstraintsFromInput(XenForo_Input $input)
    {
        $constraints = parent::getTypeConstraintsFromInput($input);

        $resManIds = $input->filterSingle('resource_manager_ids', XenForo_Input::UINT, array(
            'array' => true
        ));
        if ($resManIds && !in_array(0, $resManIds)) {
            $resManIds = array_unique($resManIds);

            /* @var $resourceManagerModel Waindigo_ResMans_Model_ResourceManager */
            $resourceManagerModel = XenForo_Model::create('Waindigo_ResMans_Model_ResourceManager');

            $categories = $resourceManagerModel->getCategoryAssociationsByResourceManagers($resManIds);

            $rescat = array();
            if (!empty($constraints['rescat'])) {
                $rescat = explode(',', $constraints['rescat']);
            }
            $rescat = array_unique(array_merge($categories, $rescat));

            $constraints['rescat'] = implode(',', $rescat);

            unset($constraints['resman']); // just 0
        }

        return $constraints;
    } /* END getTypeConstraintsFromInput */

    /**
     *
     * @see XenResource_Search_DataHandler_Update::processConstraint()
     */
    public function processConstraint(XenForo_Search_SourceHandler_Abstract $sourceHandler, $constraint, $constraintInfo,
        array $constraints)
    {
        switch ($constraint) {
            case 'resman':
                if ($constraintInfo) {
                    return array(
                        'metadata' => array(
                            'resman',
                            preg_split('/\D+/', strval($constraintInfo))
                        )
                    );
                }
                break;
        }

        return parent::processConstraint($sourceHandler, $constraint, $constraintInfo, $constraints);
    } /* END processConstraint */

    /**
     * Gets the search form controller response for this type.
     *
     * @see XenForo_Search_DataHandler_Abstract::getSearchFormControllerResponse()
     */
    public function getSearchFormControllerResponse(XenForo_ControllerPublic_Abstract $controller, XenForo_Input $input,
        array $viewParams)
    {
        $response = parent::getSearchFormControllerResponse($controller, $input, $viewParams);

        if ($response instanceof XenForo_ControllerResponse_View) {
            $resourceManagers = XenForo_Application::getSimpleCacheData(self::SIMPLE_CACHE_KEY);

            $response->params['resourceManagers'] = $resourceManagers;
        }

        return $response;
    } /* END getSearchFormControllerResponse */
}