<?php

/**
 *
 * @see XenResource_Model_Resource
 */
class Waindigo_ResMans_Extend_XenResource_Model_Resource extends XFCP_Waindigo_ResMans_Extend_XenResource_Model_Resource
{

    /**
     *
     * @see XenResource_Model_Resource::prepareResourceFetchOptions()
     */
    public function prepareResourceFetchOptions(array $fetchOptions)
    {
        $resourceFetchOptions = parent::prepareResourceFetchOptions($fetchOptions);

        $selectFields = $resourceFetchOptions['selectFields'];
        $joinTables = $resourceFetchOptions['joinTables'];

        $db = $this->_getDb();

        if (Waindigo_ResMans_ResourceManager::hasInstance()) {
            $resourceManager = Waindigo_ResMans_ResourceManager::getInstance();

            if (!empty($resourceManager['resource_manager_id'])) {
                $joinTables .= '
    				INNER JOIN xf_resource_manager_category_waindigo AS resource_manager_category_waindigo
    					ON (resource_manager_category_waindigo.resource_category_id = resource.resource_category_id
    					AND resource_manager_category_waindigo.resource_manager_id = ' .
                     $this->_getDb()->quote($resourceManager['resource_manager_id']) . ')';
            }
        }

        if (!empty($fetchOptions['join']) && $fetchOptions['join'] & self::FETCH_CATEGORY)
        {
            $selectFields .= ',
				category.resource_manager_id_waindigo';
        } else {
            $selectFields .= ',
				category_waindigo.resource_manager_id_waindigo';
            $joinTables .= '
				LEFT JOIN xf_resource_category AS category_waindigo ON
					(category_waindigo.resource_category_id = resource.resource_category_id)';
        }

        return array(
            'selectFields' => $selectFields,
            'joinTables' => $joinTables
        );
    } /* END prepareResourceFetchOptions */

    /**
     * Get the list of tab order choices mapped to user-friendly names.
     *
     * @return array
     */
    public function getTabOrderChoices()
    {
        return array(
            'last_update' => new XenForo_Phrase('latest_updates'), /* END 'last_update' */
            'resource_date' => new XenForo_Phrase('newest_resources'), /* END 'resource_date' */
            'download_count' => new XenForo_Phrase('most_downloaded'), /* END 'download_count' */
            'rating_weighted' => new XenForo_Phrase('top_resources'), /* END 'rating_weighted' */
        );
    } /* END getTabOrderChoices */ /* END getDefaultOrderOptions */

    public function getTabLabel($key)
    {
        $choices = $this->getTabOrderChoices();

        if (!empty($choices[$key])) {
            return $choices[$key];
        }

        return false;
    } /* END getTabLabel */

    public function getTabOrderChoiceOptions($selected = null, $reverseSelected = false)
    {
        $choices = $this->getTabOrderChoices();

        $options = array();
        foreach ($choices as $key => $title) {
            $isSelected = is_array($selected) ? in_array($key, $selected) : ($selected == $key);
            $options[$key] = array(
            	'label' => $title,
                'value' => $key,
                'selected' => $reverseSelected ? !$isSelected : $isSelected
            );
        }

        return $options;
    } /* END getTabOrderChoiceOptions */
}