<?php

/**
 *
 * @see XenResource_Model_Category
 */
class Waindigo_ResMans_Extend_XenResource_Model_Category extends XFCP_Waindigo_ResMans_Extend_XenResource_Model_Category
{

    protected $_waindigoViewableCategoriesCache = array();

    public function getViewableCategories(array $fetchOptions = array(), array $viewingUser = null)
    {
        $viewableCategories = parent::getViewableCategories($fetchOptions, $viewingUser);

        if (Waindigo_ResMans_ResourceManager::hasInstance()) {
            $resourceManager = Waindigo_ResMans_ResourceManager::getInstance();

            if (!empty($resourceManager['resource_manager_id'])) {
                $this->_waindigoViewableCategoriesCache[$resourceManager['resource_manager_id']] = $viewableCategories;
            }
        }

        return $viewableCategories;
    } /* END getViewableCategories */

    /**
     *
     * @see XenResource_Model_Category::prepareCategoryFetchOptions()
     */
    public function prepareCategoryFetchOptions(array $fetchOptions)
    {
        $categoryFetchOptions = parent::prepareCategoryFetchOptions($fetchOptions);

        $selectFields = $categoryFetchOptions['selectFields'];
        $joinTables = $categoryFetchOptions['joinTables'];

        $db = $this->_getDb();

        if (Waindigo_ResMans_ResourceManager::hasInstance()) {
            $resourceManager = Waindigo_ResMans_ResourceManager::getInstance();

            if (!empty($resourceManager['resource_manager_id'])) {
                $selectFields .= ',
    				IF (parent_resource_manager_category_waindigo.resource_category_id, parent_resource_manager_category_waindigo.resource_category_id, 0) AS parent_category_id';
                $joinTables .= '
    				INNER JOIN xf_resource_manager_category_waindigo AS resource_manager_category_waindigo
    					ON (resource_manager_category_waindigo.resource_category_id = resource_category.resource_category_id
    					AND resource_manager_category_waindigo.resource_manager_id = ' .
                     $this->_getDb()->quote($resourceManager['resource_manager_id']) . ')
    				LEFT JOIN xf_resource_manager_category_waindigo AS parent_resource_manager_category_waindigo
    					ON (parent_resource_manager_category_waindigo.resource_category_id = resource_category.parent_category_id
    					AND parent_resource_manager_category_waindigo.resource_manager_id = ' .
                     $this->_getDb()->quote($resourceManager['resource_manager_id']) . ')';
            }
        }

        return array(
            'selectFields' => $selectFields,
            'joinTables' => $joinTables
        );
    } /* END prepareCategoryFetchOptions */

    public function getCategoryBreadcrumb(array $category, $includeSelf = true)
    {
        $breadcrumbs = parent::getCategoryBreadcrumb($category, $includeSelf);

        if (Waindigo_ResMans_ResourceManager::hasInstance()) {
            $resourceManager = Waindigo_ResMans_ResourceManager::getInstance();

            if (!empty($resourceManager['resource_manager_id'])) {
                if (isset($this->_waindigoViewableCategoriesCache[$resourceManager['resource_manager_id']])) {
                    $viewableCategories = $this->_waindigoViewableCategoriesCache[$resourceManager['resource_manager_id']];
                } else {
                    $viewableCategories = $this->getViewableCategories();
                }
                $reversedBreadcrumbs = array_reverse($breadcrumbs, true);
                $breadcrumbs = array();
                foreach ($reversedBreadcrumbs as $catId => $breadcrumb) {
                    if (isset($viewableCategories[$catId])) {
                        $breadcrumbs[$catId] = $breadcrumb;
                    } else {
                        break;
                    }
                }
                $breadcrumbs = array_reverse($breadcrumbs, true);
            }
        }

        return $breadcrumbs;
    } /* END getCategoryBreadcrumb */
}