<?php

/**
 *
 * @see XenResource_DataWriter_Category
 */
class Waindigo_ResMans_Extend_XenResource_DataWriter_Category extends XFCP_Waindigo_ResMans_Extend_XenResource_DataWriter_Category
{

    protected function _getFields()
    {
        $fields = parent::_getFields();

        $fields['xf_resource_category']['resource_manager_id_waindigo'] = array(
            'type' => self::TYPE_UINT,
            'default' => 0
        );

        return $fields;
    } /* END _getFields */

    protected function _preSave()
    {
        if (isset($GLOBALS['XenResource_ControllerAdmin_Category'])) {
            /* @var $controller XenResource_ControllerAdmin_Category */
            $controller = $GLOBALS['XenResource_ControllerAdmin_Category'];

            $input = $controller->getInput()->filter(
                array(
                    'resource_manager_override' => XenForo_Input::UINT,
                    'resource_manager_id_waindigo' => XenForo_Input::UINT
                ));

            if ($input['resource_manager_override']) {
                $this->set('resource_manager_id_waindigo', $input['resource_manager_id_waindigo']);
            } else {
                $this->set('resource_manager_id_waindigo', 0);
            }
        }

        parent::_preSave();
    } /* END _preSave */
}