<?php

/**
 *
 * @see XenResource_ControllerPublic_Resource
 */
class Waindigo_ResMans_Extend_XenResource_ControllerPublic_Resource extends XFCP_Waindigo_ResMans_Extend_XenResource_ControllerPublic_Resource
{

    /**
     *
     * @see XenResource_ControllerPublic_Resource::_preDispatch()
     */
    protected function _preDispatch($action)
    {
        $xenOptions = XenForo_Application::getOptions();

        if (!$xenOptions->waindigo_resMans_showResourcesTab) {
            if (Waindigo_ResMans_ResourceManager::hasInstance()) {
                $resourceManager = Waindigo_ResMans_ResourceManager::getInstance();
                if (empty($resourceManager['resource_manager_id'])) {
                    if ($resourceId = $this->_input->filterSingle('resource_id', XenForo_Input::UINT)) {
                        list($resource, $category) = $this->_getResourceViewInfo();

                        if ($resource && !empty($resource['resource_manager_id_waindigo'])) {
                            $resourceManager = Waindigo_ResMans_ResourceManager::setup(
                                $resource['resource_manager_id_waindigo']);
                        }
                    }
                }
                if (!$resourceManager) {
                    throw $this->getNoPermissionResponseException();
                }

                if (isset($resourceManager['allowed_user_group_ids'])) {
                    if ($xenOptions->waindigo_resMans_showNoPermissionIfNotVisible) {
                        /* @var $resourceManagerModel Waindigo_ResMans_Model_ResourceManager */
                        $resourceManagerModel = XenForo_Model::create('Waindigo_ResMans_Model_ResourceManager');

                        if (!$resourceManagerModel->verifyResourceManagerIsUsable($resourceManager->toArray())) {
                            throw $this->getNoPermissionResponseException();
                        }
                    }
                }
            }
        }

        parent::_preDispatch($action);
    } /* END _preDispatch */

    /**
     *
     * @see XenResource_ControllerPublic_Resource::actionIndex()
     */
    public function actionIndex()
    {
        if (Waindigo_ResMans_ResourceManager::hasInstance()) {
            $resourceManager = Waindigo_ResMans_ResourceManager::getInstance();
            if (!empty($resourceManager['default_tab'])) {
                $order = $this->_input->filterSingle('order', XenForo_Input::STRING);
                if (!$order) {
                    $order = $resourceManager['default_tab'];
                    $this->_request->setParam('order', $order);
                }
            }
        }

        $response = parent::actionIndex();

        if ($response instanceof XenForo_ControllerResponse_View) {
            if (!empty($resourceManager['resource_manager_id'])) {
                $response->params['activeAuthors'] = array();
                $response->params['resourceManager'] = $resourceManager;
                if (!empty($resourceManager['hide_tabs'])) {
                    $response->params['hideTabs'] = unserialize($resourceManager['hide_tabs']);
                }
                if (!empty($resourceManager['default_tab'])) {
                    $response->params['defaultTab'] = $resourceManager['default_tab'];
                    $response->params['defaultTabLabel'] = $this->_getResourceModel()->getTabLabel(
                        $resourceManager['default_tab']);
                }
            }
        }

        return $response;
    } /* END actionIndex */

    /**
     *
     * @see XenResource_ControllerPublic_Resource::actionCategory()
     */
    public function actionCategory()
    {
        if (Waindigo_ResMans_ResourceManager::hasInstance()) {
            $resourceManager = Waindigo_ResMans_ResourceManager::getInstance();
            if (!empty($resourceManager['default_tab'])) {
                $order = $this->_input->filterSingle('order', XenForo_Input::STRING);
                if (!$order) {
                    $order = $resourceManager['default_tab'];
                    $this->_request->setParam('order', $order);
                }
            }
        }

        $response = parent::actionCategory();

        if ($response instanceof XenForo_ControllerResponse_View) {
            if (!empty($resourceManager['resource_manager_id'])) {
                $response->params['activeAuthors'] = array();
                $response->params['resourceManager'] = $resourceManager;
                if (!empty($resourceManager['hide_tabs'])) {
                    $response->params['hideTabs'] = unserialize($resourceManager['hide_tabs']);
                }
                if (!empty($resourceManager['default_tab'])) {
                    $response->params['defaultTab'] = $resourceManager['default_tab'];
                    $response->params['defaultTabLabel'] = $this->_getResourceModel()->getTabLabel(
                        $resourceManager['default_tab']);
                }
            }
        }

        return $response;
    } /* END actionCategory */

    protected function _getResourceAddOrEditResponse(array $resource, array $category, array $attachments = array())
    {
        if (!empty($category['resource_manager_id_waindigo'])) {
            $resourceManager = Waindigo_ResMans_ResourceManager::getInstance();
            if (empty($resourceManager['resource_manager_id']) ||
                 $resourceManager['resource_manager_id'] != $category['resource_manager_id_waindigo']) {

                Waindigo_ResMans_ResourceManager::setup($category['resource_manager_id_waindigo']);

                if (!empty($resource['resource_id'])) {
                    $this->canonicalizeRequestUrl(XenForo_Link::buildPublicLink('resources/edit', $resource));
                } else {
                    $this->canonicalizeRequestUrl(XenForo_Link::buildPublicLink('resources/add'));
                }
            }
        }

        return parent::_getResourceAddOrEditResponse($resource, $category, $attachments);
    } /* END _getResourceAddOrEditResponse */
}