<?php

/**
 *
 * @see Waindigo_RssFeeds_Listener_ContainerPublicParams
 */
class Waindigo_ResMans_Extend_Waindigo_RssFeeds_Listener_ContainerPublicParams extends XFCP_Waindigo_ResMans_Extend_Waindigo_RssFeeds_Listener_ContainerPublicParams
{

    const SIMPLE_CACHE_KEY = 'waindigo_resMans_resourceManagers';

    public function run()
    {
        $xenOptions = XenForo_Application::get('options');

        $resourceManagers = XenForo_Application::getSimpleCacheData(self::SIMPLE_CACHE_KEY);

        if ($resourceManagers) {
            foreach ($resourceManagers as $resourceManager) {
                if ($this->getParam('majorSection') == $resourceManager['original_prefix']) {
                    $rssFeed = array(
                        'title' => new XenForo_Phrase('waindigo_x_rss_feed_for_y_rssfeeds',
                            array(
                                'feedType' => $resourceManager['title'],
                                'title' => $xenOptions->boardTitle
                            )),
                        'link' => XenForo_Link::buildPublicLink($resourceManager['original_prefix'] . '/-/index') . '.rss'
                    );
                    $this->setParam('rssFeed', $rssFeed);
                    continue;
                }
            }
        }

        return parent::run();
    } /* END run */
}