<?php

/**
 *
 * @see XenResource_DataWriter_ResourceField
 */
class Waindigo_MultipleChoice_Extend_XenResource_DataWriter_ResourceField extends XFCP_Waindigo_MultipleChoice_Extend_XenResource_DataWriter_ResourceField
{

    /**
     *
     * @see XenResource_DataWriter_ResourceField::_getFields()
     */
    protected function _getFields()
    {
        $fields = parent::_getFields();

        $fields['xf_resource_field']['multiple_choice_waindigo'] = array(
            'type' => self::TYPE_UINT,
            'default' => 0
        );

        return $fields;
    } /* END _getFields */

    /**
     *
     * @see XenResource_DataWriter_ResourceField::_preSave()
     */
    protected function _preSave()
    {
        if (!empty($GLOBALS['XenResource_ControllerAdmin_Field'])) {
            /* @var $controller XenResource_ControllerAdmin_Field */
            $controller = $GLOBALS['XenResource_ControllerAdmin_Field'];

            $input = $controller->getInput()->filter(
                array(
                    'multiple_choice_waindigo' => XenForo_Input::BOOLEAN,
                    'multiple_choice_waindigo_set' => XenForo_Input::BOOLEAN
                ));

            if (in_array($this->get('field_type'), array(
                'select',
                'multiselect'
            ))) {
                if ($input['multiple_choice_waindigo_set']) {
                    $this->set('multiple_choice_waindigo', $input['multiple_choice_waindigo']);
                }
            } else {
                $this->set('multiple_choice_waindigo', 0);
            }
        }

        parent::_preSave();
    } /* END _preSave */
}