<?php

/**
 *
 * @see Waindigo_CustomFields_DataWriter_ThreadField
 */
class Waindigo_MultipleChoice_Extend_Waindigo_CustomFields_DataWriter_ThreadField extends XFCP_Waindigo_MultipleChoice_Extend_Waindigo_CustomFields_DataWriter_ThreadField
{

    /**
     *
     * @see Waindigo_CustomFields_DataWriter_ThreadField
     */
    protected function _getFields()
    {
        $fields = parent::_getFields();

        $fields['xf_thread_field']['multiple_choice_waindigo'] = array(
            'type' => self::TYPE_UINT,
            'default' => 0
        );

        return $fields;
    } /* END _getFields */

    /**
     *
     * @see Waindigo_CustomFields_DataWriter_ThreadField
     */
    protected function _preSave()
    {
        if (!empty($GLOBALS['Waindigo_CustomFields_ControllerAdmin_ThreadField'])) {
            /* @var $controller Waindigo_CustomFields_ControllerAdmin_ThreadField */
            $controller = $GLOBALS['Waindigo_CustomFields_ControllerAdmin_ThreadField'];

            $input = $controller->getInput()->filter(
                array(
                    'multiple_choice_waindigo' => XenForo_Input::BOOLEAN,
                    'multiple_choice_waindigo_set' => XenForo_Input::BOOLEAN
                ));

            if (in_array($this->get('field_type'), array(
                'select',
                'multiselect'
            ))) {
                if ($input['multiple_choice_waindigo_set']) {
                    $this->set('multiple_choice_waindigo', $input['multiple_choice_waindigo']);
                }
            } else {
                $this->set('multiple_choice_waindigo', 0);
            }
        }

        parent::_preSave();
    } /* END _preSave */
}