<?php

class Waindigo_LoginAsUser_Model_LoginAsUser extends XenForo_Model
{

    public function startConversation(array $conversation, $message, array $recipients, XenForo_Visitor $visitor = null)
    {
        if (!$visitor) {
            $visitor = XenForo_Visitor::getInstance();
        }

        $message = $message->__toString();

        $conversationModel = $this->_getConversationModel();
        if ($conversationModel->canStartConversations()) {
            if (in_array($visitor['username'], $recipients)) {
                unset($recipients[array_search($visitor['username'], $recipients)]);
            }
            $users = array();
            if (!empty($recipients)) {
                $users = $this->_getUserModel()->getUsersByNames($recipients,
                    array(
                        'join' => XenForo_Model_User::FETCH_USER_PRIVACY + XenForo_Model_User::FETCH_USER_OPTION,
                        'followingUserId' => $visitor['user_id']
                    ));
            }
            $recipients = array();
            foreach ($users as $user) {
                $errorPhraseKey = '';
                if ($conversationModel->canStartConversationWithUser($user, $errorPhraseKey, $visitor->toArray())) {
                    $recipients[] = $user['username'];
                }
            }

            if (!empty($recipients)) {
                $conversationDw = XenForo_DataWriter::create('XenForo_DataWriter_ConversationMaster');
                $conversationDw->setExtraData(XenForo_DataWriter_ConversationMaster::DATA_ACTION_USER,
                    $visitor->toArray());
                $conversationDw->setExtraData(XenForo_DataWriter_ConversationMaster::DATA_MESSAGE, $message);
                $conversationDw->set('user_id', $visitor['user_id']);
                $conversationDw->set('username', $visitor['username']);
                $conversationDw->bulkSet($conversation);
                $conversationDw->set('open_invite', true);
                $conversationDw->set('conversation_open', true);

                $conversationDw->addRecipientUserNames($recipients); // checks permissions


                $messageDw = $conversationDw->getFirstMessageDw();
                $messageDw->set('message', $message);

                $conversationDw->preSave();

                $conversationDw->save();
                $conversation = $conversationDw->getMergedData();

                $this->_getConversationModel()->markConversationAsRead($conversation['conversation_id'],
                    XenForo_Visitor::getUserId(), XenForo_Application::$time);
                return $conversation;
            }
        }
        return false;
    } /* END startConversation */

    /**
     *
     * @return XenForo_Model_User
     */
    protected function _getUserModel()
    {
        return $this->getModelFromCache('XenForo_Model_User');
    } /* END _getUserModel */

    /**
     *
     * @return XenForo_Model_Conversation
     */
    protected function _getConversationModel()
    {
        return $this->getModelFromCache('XenForo_Model_Conversation');
    } /* END _getConversationModel */
}