<?php

class Waindigo_LoginAsUser_Listener_VisitorSetup extends Waindigo_Listener_VisitorSetup
{

    protected static $_runOnce = false;

    public static function visitorSetup(XenForo_Visitor $visitor)
    {
        self::extend($visitor, 'Waindigo_LoginAsUser_Extend_XenForo_Visitor');

        if ($visitor->user_id && !self::$_runOnce) {
            self::$_runOnce = true;
            if (!$visitor->hasParentInstance() && XenForo_Application::isRegistered('session')) {
                /* @var $session XenForo_Session */
                $session = XenForo_Application::get('session');
                if ($session->isRegistered('loggedInAs')) {
                    if ($visitor->getUserId() != $session->get('loggedInAs')) {
                        return Waindigo_LoginAsUser_Extend_XenForo_Visitor::setup($session->get('loggedInAs'));
                    }
                }
            }
        }
        return $visitor;
    } /* END visitorSetup */
}