<?php

class Waindigo_LoginAsUser_Listener_TemplateCreate extends Waindigo_Listener_TemplateCreate
{

    protected function _getTemplates()
    {
        return array(
            'PAGE_CONTAINER',
            'member_card'
        );
    } /* END _getTemplates */

    public static function templateCreate(&$templateName, array &$params, XenForo_Template_Abstract $template)
    {
        $templateCreate = new Waindigo_LoginAsUser_Listener_TemplateCreate($templateName, $params, $template);
        list($templateName, $params) = $templateCreate->run();
    } /* END templateCreate */

    protected function _pageContainer()
    {
        /* @var $userModel XenForo_Model_User */
        $userModel = XenForo_Model::create('XenForo_Model_User');

        /* @var $session XenForo_Session */
        $session = XenForo_Application::get('session');
        if ($session->isRegistered('loggedInAs') || $userModel->canLoginAsUsers()) {
            if ($userModel->canLoginAsUsers()) {
                $this->_params['canLoginAsUsers'] = true;
            }
            if (!XenForo_Visitor::getInstance()->is_admin && !XenForo_Visitor::getInstance()->is_moderator) {
                $this->_params['hideLoginBar'] = true;
            }
        }

        $this->_preloadTemplate('waindigo_you_are_using_as_user_loginasuser');
        $this->_preloadTemplate('waindigo_moderator_bar_loginasuser');
    } /* END _pageContainer */

    protected function _memberCard()
    {
        $this->_preloadTemplate('waindigo_member_card_link_loginasuser');
    } /* END _memberCard */
}