<?php

/**
 *
 * @see XenForo_Visitor
 */
class Waindigo_LoginAsUser_Extend_XenForo_Visitor extends XFCP_Waindigo_LoginAsUser_Extend_XenForo_Visitor
{
	/**
	 * Parent instance manager.
	 *
	 * @var XenForo_Visitor
	 */
	private static $_parentInstance;

	/**
	 * Setup the new visitor singleton and save the existing singleton.
	 *
	 * @param integer $userId User ID to setup as
	 * @param array $options
	 *
	 * @return XenForo_Visitor
	 */
	public static function setup($userId, array $options = array())
	{
		if (!isset($_parentInstance))
		{
			self::$_parentInstance = self::getInstance();
		}

		try {
		    return parent::setup($userId, $options);
		} catch (Exception $e) {
		    return self::$_parentInstance;
		}
	} /* END setup */

	/**
	 * Determines if we have a parent instance setup.
	 *
	 * @return boolean
	 */
	public static function hasParentInstance()
	{
	    return (self::$_parentInstance ? true : false);
	} /* END hasParentInstance */

	/**
	 * Gets the parent user's info.
	 *
	 * @return XenForo_Visitor
	 */
	public static final function getParentInstance()
	{
		if (!self::$_parentInstance)
		{
			return self::getInstance();
		}

		return self::$_parentInstance;
	} /* END getParentInstance */
}