<?php

abstract class Waindigo_Listener_NavigationTabs
{

    protected $_extraTabs = array();

    protected $_selectedTabId;

    /**
     *
     * @param array $extraTabs
     * @param $selectedTabId
     */
    public function __construct(array &$extraTabs, $selectedTabId)
    {
        $this->_extraTabs = $extraTabs;
        $this->_selectedTabId = $selectedTabId;
    } /* END __construct */

    public function run()
    {
        $this->_extraTabs = array_merge($this->_extraTabs, $this->_getNavigationTabs());

        return $this->_extraTabs;
    } /* END run */

    protected function _run()
    {
        try {
            return $this->run();
        } catch (Exception $e) {
            // do nothing
        }
    } /* END _run */

    /**
     * Gets the specified model object from the cache.
     * If it does not exist,
     * it will be instantiated.
     *
     * @param string $class Name of the class to load
     *
     * @return XenForo_Model
     */
    public function getModelFromCache($class)
    {
        if (!isset($this->_modelCache[$class])) {
            $this->_modelCache[$class] = XenForo_Model::create($class);
        }

        return $this->_modelCache[$class];
    } /* END getModelFromCache */

    // This only works on PHP 5.3+, so method should be overridden for now
    public static function navigationTabs(array &$extraTabs, $selectedTabId)
    {
        $class = get_called_class();
        $navigationTabs = new $class($extraTabs, $selectedTabId);
        $extraTabs = $navigationTabs->run();
    } /* END navigationTabs */

    abstract protected function _getNavigationTabs();
}