<?php

class Waindigo_InstallUpgrade_Option_AddOnChooser
{

    public static function renderCheckbox(XenForo_View $view, $fieldPrefix, array $preparedOption, $canEdit)
    {
        return self::_render('option_list_option_checkbox', $view, $fieldPrefix, $preparedOption, $canEdit);
    }

    /**
     * Renders the add-on chooser option.
     *
     * @param string Name of template to render
     * @param XenForo_View $view View object
     * @param string $fieldPrefix Prefix for the HTML form field name
     * @param array $preparedOption Prepared option info
     * @param boolean $canEdit True if an "edit" link should appear
     *
     * @return XenForo_Template_Abstract Template object
     */
    protected static function _render($templateName, XenForo_View $view, $fieldPrefix, array $preparedOption, $canEdit)
    {
        /* @var $addOnModel XenForo_Model_AddOn */
        $addOnModel = XenForo_Model::create('XenForo_Model_AddOn');

        $addOns = $addOnModel->getAllAddOns();

        $addOnOptions = array();
        $selectedIds = $preparedOption['option_value'];
        foreach ($addOns as $addOnId => $addOn) {
            $addOnOptions[$addOnId] = array(
                'value' => $addOnId,
                'label' => $addOn['title'],
                'selected' => in_array($addOnId, $selectedIds)
            );
        }


        $preparedOption['formatParams'] = $addOnOptions;

        return XenForo_ViewAdmin_Helper_Option::renderOptionTemplateInternal($templateName, $view, $fieldPrefix,
            $preparedOption, $canEdit, array(
                'class' => 'checkboxColumns'
            ));
    }
}