<?php

class Waindigo_InstallUpgrade_Listener_TemplatePostRender extends Waindigo_Listener_TemplatePostRender
{

    protected function _getTemplates()
    {
        return array(
            'addon_install',
            'addon_list',
            'addon_upgrade',
            'language_import',
            'object_field_import',
            'post_field_import',
            'resource_field_import',
            'social_forum_field_import',
            'style_import',
            'thread_field_import',
            'user_field_import',
            'waindigo_hotspot_import_hotspots',
            'waindigo_smilie_import_smilieimporter',
            'waindigo_trophy_import_trophies',
            'waindigo_user_group_import_usergroups',
            'waindigo_user_upgrade_import_userupgrades'
        );
    }

    public static function templatePostRender($templateName, &$content, array &$containerData,
        XenForo_Template_Abstract $template)
    {
        $templatePostRender = new Waindigo_InstallUpgrade_Listener_TemplatePostRender($templateName, $content,
            $containerData, $template);
        list($content, $containerData) = $templatePostRender->run();
    }

    protected function _addonInstall()
    {
        $pattern = '#(<input type="file" name="upload_file)(" [^>]*)(>)#';
        $replacement = '${1}[]${2} multiple="multiple"${3}';
        $this->_patternReplace($pattern, $replacement);
    }

    protected function _addonList()
    {
        $viewParams = $this->_fetchViewParams();
        $pattern = '#<li class="listItem primaryContent" id="_([A-z_]*)">.*<a class="toolsCtrl" rel="Menu">.*<ul[^>]*>#Us';
        $this->_contents = preg_replace_callback($pattern,
            array(
                $this,
                '_addonListReplace'
            ), $this->_contents);
    }

    protected function _addonListReplace(array $matches)
    {
        return $matches[0] . $this->_render('waindigo_addon_list_controls_installupgrade',
            array(
                'addOn' => array(
                    'addon_id' => $matches[1]
                )
            ));
    }

    protected function _addonUpgrade()
    {
        $viewParams = $this->_fetchViewParams();
        $pattern = '#(<input type="text" name="server_file" value=")(" class="textCtrl" id="ctrl_server_file" />)#Us';
        $replacement = '${1}' . $viewParams['addOn']['install_upgrade_filename'] . '${2}';
        $this->_patternReplace($pattern, $replacement);

        $this->_addonInstall();
    }

    protected function _copyrightNotice()
    {
        if (!XenForo_Application::get('options')->waindigo_disableCopyright_installUpgrade &&
             !Waindigo_InstallUpgrade_Listener_TemplateHook::getVisibleCopyrightNotice()) {
            $copyrightPhrase = new XenForo_Phrase('waindigo_copyright_notice_installupgrade');
            if (XenForo_Application::get('options')->waindigo_moveCopyright_installUpgrade == 'below-xenforo-copyright') {
                $pattern = '#(<div id="copyright">.*)(</div>)#Us';
                $replacement = '${1}<div id="waindigoCopyrightNotice">' . $copyrightPhrase . '</div>${2}';
                $this->_patternReplace($pattern, $replacement);
            } else {
                self::$copyrightNotice = '<div id="waindigoCopyrightNotice" class="footerLegal" style="clear:both"><div class="pageContent"><span class="muted">' .
                     $copyrightPhrase . '</span></div></div>';
                self::$_copyrightNotice = false;
                parent::_copyrightNotice();
            }
        }
    }

    protected function _languageImport()
    {
        $pattern = '#<dl class="ctrlUnit">\s*<dt><label for="ctrl_upload">.*</dl>#Us';
        $this->_replaceWithTemplateAtPattern($pattern, 'waindigo_import_fields_installupgrade');
    }

    protected function _objectFieldImport()
    {
        $this->_languageImport();
    }

    protected function _postFieldImport()
    {
        $this->_languageImport();
    }

    protected function _resourceFieldImport()
    {
        $this->_languageImport();
    }

    protected function _socialForumFieldImport()
    {
        $this->_languageImport();
    }

    protected function _styleImport()
    {
        $this->_languageImport();
    }

    protected function _threadFieldImport()
    {
        $this->_languageImport();
    }

    protected function _userFieldImport()
    {
        $this->_languageImport();
    }

    protected function _waindigoHotspotImportHotspots()
    {
        $this->_languageImport();
    }

    protected function _waindigoModeratorImportHotspots()
    {
        $this->_languageImport();
    }

    protected function _waindigoSmilieImportSmilieimporter()
    {
        $this->_languageImport();
    }

    protected function _waindigoTrophyImportTrophies()
    {
        $this->_languageImport();
    }

    protected function _waindigoUserGroupImportSmilieimporter()
    {
        $this->_languageImport();
    }

    protected function _waindigoUserUpgradeImportSmilieimporter()
    {
        $this->_languageImport();
    }
}