<?php

class Waindigo_InstallUpgrade_Listener_LoadClass extends Waindigo_Listener_LoadClass
{

    protected function _getExtendedClasses()
    {
        return array(
            'Waindigo_InstallUpgrade' => array(
                'controller' => array(
                    'Waindigo_CustomFields_ControllerAdmin_PostField',
                    'Waindigo_CustomFields_ControllerAdmin_ResourceField',
                    'Waindigo_CustomFields_ControllerAdmin_SocialForumField',
                    'Waindigo_CustomFields_ControllerAdmin_ThreadField',
                    'Waindigo_Hotspots_ControllerAdmin_Hotspot',
                    'Waindigo_ObjectFields_ControllerAdmin_ObjectField',
                    'XenForo_ControllerAdmin_AddOn',
                    'XenForo_ControllerAdmin_Language',
                    'XenForo_ControllerAdmin_Moderator',
                    'XenForo_ControllerAdmin_Smilie',
                    'XenForo_ControllerAdmin_Style',
                    'XenForo_ControllerAdmin_TemplateModification',
                    'XenForo_ControllerAdmin_Trophy',
                    'XenForo_ControllerAdmin_UserField',
                    'XenForo_ControllerAdmin_UserGroup',
                    'XenForo_ControllerAdmin_UserUpgrade',
                    'XenForo_ControllerAdmin_Home',
                    'XenForo_ControllerAdmin_Login'
                ),
                'datawriter' => array(
                    'XenForo_DataWriter_AddOn',
                    'XenForo_DataWriter_Template',
                    'XenForo_DataWriter_AdminTemplate',
                    'XenForo_DataWriter_AdminTemplateModification',
                    'XenForo_DataWriter_TemplateModification',
                    'XenForo_DataWriter_Phrase'
                ),
                'model' => array(
                    'XenForo_Model_AddOn',
                    'XenForo_Model_Counters'
                ),
            ),
        );
    }

    public static function loadClassController($class, array &$extend)
    {
        $extend = self::createAndRun('Waindigo_InstallUpgrade_Listener_LoadClass', $class, $extend, 'controller');
    }

    public static function loadClassDataWriter($class, array &$extend)
    {
        $extend = self::createAndRun('Waindigo_InstallUpgrade_Listener_LoadClass', $class, $extend, 'datawriter');
    }

    public static function loadClassModel($class, array &$extend)
    {
        $extend = self::createAndRun('Waindigo_InstallUpgrade_Listener_LoadClass', $class, $extend, 'model');
    }
}