<?php

class Waindigo_InstallUpgrade_Listener_ContainerAdminParams
{

    public static $outdatedAddOnCount = 0;

    public static function containerAdminParams(array &$params, XenForo_Dependencies_Abstract $dependencies)
    {
        $xenOptions = XenForo_Application::get('options');

        if ($xenOptions->waindigo_installUpgrade_showOutdatedBalloon) {
            /* @var $addOnModel XenForo_Model_AddOn */
            $addOnModel = XenForo_Model::create('XenForo_Model_AddOn');

            $addOns = $addOnModel->getAllAddOns();

            $outdatedAddOnCount = 0;
            foreach ($addOns as $addOnId => $addOn) {
                if ($xenOptions->waindigo_installUpgrade_outdatedEnabledOnly && !$addOn['active']) {
                    continue;
                }
                if ($addOn['install_upgrade_updated']) {
                    $outdatedAddOnCount++;
                }
            }

            $params['outdatedAddOnCount'] = $outdatedAddOnCount;

            self::$outdatedAddOnCount = $outdatedAddOnCount;
        }
    }
}