<?php

class Waindigo_InstallUpgrade_Helper_File
{

    public static function processFiles(array $filenames)
    {
        $allFilenames = $filenames;
        foreach ($filenames as $filename) {
            if (is_dir($filename)) {
                self::_addFilesInDirectory($filename, $allFilenames);
            }
        }
    }

    protected static function _addFilesInDirectory($filename, array &$filenames)
    {
        $handle = opendir($filename);
        if ($handle) {
            while (false !== ($file = readdir($handle))) {
                if ((substr($file, 0, 1) != ".")) {
                    $filenames[] = $filename . '/' . $file;
                    if (is_dir($filename . '/' . $file)) {
                        self::_addFilesInDirectory($filename . '/' . $file, $filenames);
                    }
                }
            }
            closedir($handle);
        }
    }

    public static function processJsFiles($filename)
    {
        $handle = opendir($filename);
        if ($handle) {
            while (false !== ($file = readdir($handle))) {
                if ((substr($file, 0, 1) != ".")) {
                    if (pathinfo($file, PATHINFO_EXTENSION) == 'js') {
                        $jsCode = '';
                        if (file_exists($filename . '/full/' . $file)) {
                            $jsCode = file_get_contents($filename . '/full/' . $file);
                            $destination = $filename . '/' . $file;
                        } elseif (pathinfo($filename, PATHINFO_FILENAME) == 'full' &&
                             !file_exists(pathinfo($filename, PATHINFO_BASENAME) . $file)) {
                            $jsCode = file_get_contents($filename . '/' . $file);
                            $destination = pathinfo($filename, PATHINFO_DIRNAME) . '/' . $file;
                        }
                        if ($jsCode) {
                            try {
                                $compiler = Waindigo_InstallUpgrade_Helper_Http::getClient(
                                    'http://closure-compiler.appspot.com/compile');

                                $compiler->setParameterPost('js_code', $jsCode);
                                $compiler->setParameterPost('output_info', 'compiled_code');
                                $compiler->setParameterPost('compilation_level', 'SIMPLE_OPTIMIZATIONS');
                                $compiler->setParameterPost('output_format', 'text');
                                $compilerResponse = $compiler->request('POST');

                                if ($compiler && $compilerResponse->getStatus() == 200) {
                                    $body = $compilerResponse->getBody();
                                    if (trim($body)) {
                                        file_put_contents($destination, $body);
                                    } else {
                                        file_put_contents($destination, $jsCode);
                                    }
                                }
                            } catch (Zend_Http_Client_Exception $e) {
                                file_put_contents($destination, $jsCode);
                            }
                        }
                    }
                    if (is_dir($filename . '/' . $file)) {
                        self::processJsFiles($filename . '/' . $file);
                    }
                }
            }
            closedir($handle);
        }
        if (!file_exists($filename . '/index.html')) {
            file_put_contents($filename . '/index.html', '');
        }
    }
}