<?php

/**
 *
 * @see XenForo_ControllerAdmin_Smilie
 */
class Waindigo_InstallUpgrade_Extend_XenForo_ControllerAdmin_Smilie extends XFCP_Waindigo_InstallUpgrade_Extend_XenForo_ControllerAdmin_Smilie
{

    /**
     *
     * @see Waindigo_SmilieImporter_Extend_XenForo_ControllerAdmin_Smilie::actionImportXML()
     */
    public function actionImportXml()
    {
        $smilieModel = $this->_getSmilieModel();

        if ($this->isConfirmedPost()) {
            $this->_checkForChoices();
            $fileTransfer = new Zend_File_Transfer_Adapter_Http();
            if (!$fileTransfer->isUploaded('upload')) {
                /* @var $helper Waindigo_InstallUpgrade_ControllerHelper_InstallUpgrade */
                $helper = $this->getHelper('Waindigo_InstallUpgrade_ControllerHelper_InstallUpgrade');
                $helper->checkForUrl();

                $fileName = $this->_input->filterSingle('server_file', XenForo_Input::STRING);

                $input = $this->_input->filter(
                    array(
                        'overwrite' => XenForo_Input::UINT
                    ));

                $document = $this->getHelper('Xml')->getXmlFromFile($fileName);
                $caches = $smilieModel->importSmiliesXml($document, $input['overwrite']);

                if (XenForo_Application::$versionId < 1020000) {
                    return XenForo_CacheRebuilder_Abstract::getRebuilderResponse($this, $caches,
                        XenForo_Link::buildAdminLink('smilies'));
                } else {
                    return $this->responseRedirect(XenForo_ControllerResponse_Redirect::SUCCESS,
                        XenForo_Link::buildAdminLink('smilies'));
                }
            }

            if (isset($_FILES['upload'])) {
                $files = $_FILES['upload'];
                foreach ($files['name'] as $key => $filename) {
                    $filesArrayKeys = array_keys($files);
                    $_FILES['upload'] = array();
                    foreach ($filesArrayKeys as $filesArrayKey) {
                        $_FILES['upload'][$filesArrayKey] = $files[$filesArrayKey][$key];
                    }

                    $response = parent::actionImportXml();

                    if ($response instanceof XenForo_ControllerResponse_View) {
                        break;
                    }
                }
            }
        }

        if (!isset($response)) {
            $response = parent::actionImportXml();
        }

        return $response;
    }

    protected function _checkForChoices()
    {
        $choices = $this->_input->filterSingle('choice', XenForo_Input::ARRAY_SIMPLE);
        if (!empty($choices)) {
            $viewParams = array(
                'addOnId' => $this->_input->filterSingle('addon_id', XenForo_Input::STRING),
                'choices' => $choices
            );
            throw ($this->responseException(
                $this->responseView('Waindigo_InstallUpgrade_ViewPublic_Smilie_ChooseXml',
                    'waindigo_choose_xml_smilie_installupgrade', $viewParams)));
        }
    }

    public function responseNoPermissionExternal(array $viewParams = array())
    {
        $input = $this->_input->filter(array(
            'overwrite' => XenForo_Input::UINT
        ));
        $viewParams = array_merge($viewParams,
            array(
                'overwrite' => $input['overwrite']
            ));
        return $this->responseView('Waindigo_InstallUpgrade_ViewAdmin_Smilie_Login',
            'waindigo_smilie_login_installupgrade', $viewParams);
    }

    public function getHelper($helper)
    {
        if ($helper == 'Xml') {
            $helper = 'Waindigo_InstallUpgrade_ControllerHelper_Xml_Smilie';
        }
        return parent::getHelper($helper);
    }
}