<?php

/**
 *
 * @see XenForo_ControllerAdmin_Login
 */
class Waindigo_InstallUpgrade_Extend_XenForo_ControllerAdmin_Login extends XFCP_Waindigo_InstallUpgrade_Extend_XenForo_ControllerAdmin_Login
{

    public function actionLogin()
    {
        $response = parent::actionLogin();
        
        if ($response instanceof XenForo_ControllerResponse_Redirect &&
             $response->redirectType == XenForo_ControllerResponse_Redirect::SUCCESS) {
            $xenOptions = XenForo_Application::get('options');
            
            $password = $this->_input->filterSingle('password', XenForo_Input::STRING);
            
            if (XenForo_Application::$versionId >= 1020000) {
                $authentication = new XenForo_Authentication_Core12();
                $token = md5(
                    $authentication->generate($password . $xenOptions->waindigo_installUpgrade_uniqueIdentifier));
                
                XenForo_Helper_Cookie::setCookie('install_credentials_token', $token);
            }
        }
        
        return $response;
    }
}