<?php

/**
 *
 * @see XenForo_ControllerAdmin_Home
 */
class Waindigo_InstallUpgrade_Extend_XenForo_ControllerAdmin_Home extends XFCP_Waindigo_InstallUpgrade_Extend_XenForo_ControllerAdmin_Home
{

    public function actionIndex()
    {
        $response = parent::actionIndex();

        if ($response instanceof XenForo_ControllerResponse_View) {
            $xenOptions = XenForo_Application::get('options');

            if ($xenOptions->waindigo_installUpgrade_allowBroadcast) {
                $broadcast = XenForo_Application::getSimpleCacheData('installUpgradeBroadcast');

                if ($broadcast) {
                    $formatter = XenForo_BbCode_Formatter_Base::create(
                        'Waindigo_InstallUpgrade_BbCode_Formatter_Broadcast');
                    $parser = XenForo_BbCode_Parser::create($formatter);

                    $broadcast['message'] = $parser->render($broadcast['message']);

                    $response->params['installUpgradeBroadcast'] = $broadcast;
                }
            }
            $boardTotals = $response->params['boardTotals'];

            if (!isset($boardTotals['activeUsers'])) {
                $boardTotals = $this->getModelFromCache('XenForo_Model_Counters')->rebuildBoardTotalsCounter();

                $response->params['boardTotals'] = $boardTotals;
            }

            $response->params['users']['active'] = $boardTotals['activeUsers'];
        }

        return $response;
    }
}