<?php

class Waindigo_InstallUpgrade_ControllerHelper_Xml_ThreadField extends XenForo_ControllerHelper_Xml
{

    public function getXmlFromFile($file)
    {
        if ($file instanceof XenForo_Upload) {
            $file = $file->getTempFile();
        }

        /* @var $installUpgradeModel Waindigo_InstallUpgrade_Model_InstallUpgrade */
        $installUpgradeModel = XenForo_Model::create('Waindigo_InstallUpgrade_Model_InstallUpgrade');

        $file = $installUpgradeModel->extractFromFile($file, 'field');

        $skippedFiles = $installUpgradeModel->getSkippedFiles();
        if (!empty($skippedFiles)) {
            $viewParams['skippedFiles'] = $skippedFiles;
            throw $this->_controller->responseException(
                $this->_controller->responseView('Waindigo_InstallUpgrade_ViewPublic_ThreadField_FilesSkipped',
                    'waindigo_files_skipped_thread_field_installupgrade', $viewParams));
        }

        if (is_array($file)) {
            $input = $this->_controller->getInput()->filter(
                array(
                    'target' => XenForo_Input::STRING,
                    'display_group' => XenForo_Input::STRING,
                    'overwrite_field_id' => XenForo_Input::STRING
                ));
            $viewParams = array(
                'choices' => $file,
                'target' => $input['target'],
                'displayGroup' => $input['display_group'],
                'overwriteFieldId' => $input['overwrite_field_id']
            );
            throw $this->_controller->responseException(
                $this->_controller->responseView('Waindigo_InstallUpgrade_ViewPublic_ThreadField_ChooseXml',
                    'waindigo_choose_xml_thread_field_installupgrade', $viewParams));
        }

        return parent::getXmlFromFile($file);
    }
}