<?php

class Waindigo_InstallUpgrade_ControllerHelper_Xml_Style extends XenForo_ControllerHelper_Xml
{

    public function getXmlFromFile($file)
    {
        if ($file instanceof XenForo_Upload) {
            $file = $file->getTempFile();
        }

        /* @var $installUpgradeModel Waindigo_InstallUpgrade_Model_InstallUpgrade */
        $installUpgradeModel = XenForo_Model::create('Waindigo_InstallUpgrade_Model_InstallUpgrade');

        $file = $installUpgradeModel->extractFromFile($file, 'style');

        $skippedFiles = $installUpgradeModel->getSkippedFiles();
        if (!empty($skippedFiles)) {
            $viewParams['skippedFiles'] = $skippedFiles;
            throw $this->_controller->responseException(
                $this->_controller->responseView('Waindigo_InstallUpgrade_ViewPublic_Style_FilesSkipped',
                    'waindigo_files_skipped_style_installupgrade', $viewParams));
        }

        if (is_array($file)) {
            $input = $this->_controller->getInput()->filter(
                array(
                    'target' => XenForo_Input::STRING,
                    'parent_style_id' => XenForo_Input::UINT,
                    'overwrite_style_id' => XenForo_Input::UINT
                ));
            $viewParams = array(
                'choices' => $file,
                'target' => $input['target'],
                'parentStyleId' => $input['parent_style_id'],
                'overwriteStyleId' => $input['overwrite_style_id']
            );
            throw $this->_controller->responseException(
                $this->_controller->responseView('Waindigo_InstallUpgrade_ViewPublic_Style_ChooseXml',
                    'waindigo_choose_xml_style_installupgrade', $viewParams));
        }

        return parent::getXmlFromFile($file);
    }
}