<?php

class Waindigo_InstallUpgrade_ControllerHelper_Multiple extends XenForo_ControllerHelper_Abstract
{

    public function getAddOnsFromDirectory($directory)
    {
        $fileMd5s = array();
        $addOns = array();
        
        foreach ($iterator = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($directory), 
            RecursiveIteratorIterator::SELF_FIRST) as $item) {
            if ($item->isDir()) {
                // do nothing
            } else {
                $fileName = $directory . DIRECTORY_SEPARATOR . $iterator->getSubPathName();
                $fileMd5 = md5_file($fileName);
                if (in_array($fileMd5, $fileMd5s)) {
                    continue;
                }
                $fileMd5s[] = $fileMd5;
                $addOn = $this->_getAddOnFromFile($fileName);
                if (!$addOn) {
                    continue;
                }
                if ($addOn['addon_id'] && $addOn['version_id'] && $addOn['version_string']) {
                    $addOn['server_file'] = $fileName;
                    $addOns[$addOn['addon_id']][$addOn['version_id']][$addOn['version_string']][] = $addOn;
                }
            }
        }
        
        $addOnsOrdered = array();
        foreach ($addOns as $addOnId => &$addOn) {
            krsort($addOn);
            foreach ($addOn as &$addOnVersions) {
                if (PHP_VERSION_ID < 50400) {
                    krsort($addOnVersions);
                } else {
                    krsort($addOnVersions, SORT_NATURAL);
                }
                foreach ($addOnVersions as $addOnDetails) {
                    foreach ($addOnDetails as $addOnDetail) {
                        $addOnsOrdered[$addOnId][] = $addOnDetail;
                    }
                }
            }
        }
        
        return $addOnsOrdered;
    }

    protected function _getAddOnFromFile($fileName)
    {
        if (!file_exists($fileName)) {
            return false;
        }
        
        $fh = fopen($fileName, "r");
        
        $blob = fgets($fh, 6);
        
        if (strpos($blob, 'Rar') !== false) {
            return $this->_getAddOnFromArchive($fileName, 'Rar');
        } elseif (strpos($blob, 'PK') !== false) {
            return $this->_getAddOnFromArchive($fileName, 'Zip');
        } elseif (strpos($blob, 'xml') !== false) {
            return $this->_getAddOnFromXml($fileName);
        }
        
        return false;
    }

    protected function _getAddOnFromArchive($fileName)
    {
        $zipArchive = new ZipArchive();
        
        $zipArchive->open($fileName);
        
        $entries = array();
        $version = 0;
        for ($i = 0; $i < $zipArchive->numFiles; $i++) {
            $stat = $zipArchive->statIndex($i);
            if (preg_match('#.xml$#', $stat['name'])) {
                $data = $zipArchive->getFromIndex($i);
                if ($data) {
                    $addOn = $this->_getAddOnFromXml($data, false);
                    if ($addOn) {
                        return $addOn;
                    }
                }
            }
        }
        
        $zipArchive->close();
        
        return false;
    }

    protected function _getAddOnFromXml($data, $dataIsUrl = true)
    {
        try {
            $xml = new SimpleXMLElement($data, 0, $dataIsUrl);
            
            $xmlType = (string) $xml->getName();
            
            if ($xmlType != 'addon') {
                return false;
            }
            
            $addOn['addon_id'] = (string) $xml['addon_id'];
            $addOn['title'] = (string) $xml['title'];
            $addOn['version_id'] = (string) $xml['version_id'];
            $addOn['version_string'] = (string) $xml['version_string'];
            
            return $addOn;
        } catch (Exception $e) {
            return false;
        }
    }
}