<?php

class Waindigo_InstallUpgrade_ControllerHelper_InstallUpgrade extends XenForo_ControllerHelper_Abstract
{

    protected static $_fileName = '';

    public function checkForTitle()
    {
        $input = $this->_controller->getInput();
        
        $serverFile = $input->filterSingle('server_file', XenForo_Input::STRING);
        
        if ($serverFile && !filter_var($serverFile, FILTER_VALIDATE_URL) && !file_exists($serverFile)) {
            try {
                $client = Waindigo_InstallUpgrade_Helper_Http::getClient('https://waindigo.org/resources/url.json');
                $client->setParameterGet('title', $serverFile);
                $response = $client->request('GET');
                $body = json_decode($response->getBody(), true);
                $url = $body['url'];
                $this->_controller->getRequest()->setParam('server_file', $url);
            } catch (Exception $e) {
            }
        }
    }

    public function checkForUrl($returnBody = false)
    {
        /* @var $installUpgradeModel Waindigo_InstallUpgrade_Model_InstallUpgrade */
        $installUpgradeModel = $this->_controller->getModelFromCache('Waindigo_InstallUpgrade_Model_InstallUpgrade');
        
        $options = $this->_controller->getInput()->filter(
            array(
                'original_server_file' => XenForo_Input::STRING,
                'server_file' => XenForo_Input::STRING,
                'status' => XenForo_Input::UINT,
                'redirect' => XenForo_Input::STRING,
                'post_params' => XenForo_Input::ARRAY_SIMPLE,
                'username' => XenForo_Input::STRING,
                'password' => XenForo_Input::STRING,
                'auth_type' => XenForo_Input::STRING,
                'store_credentials' => XenForo_Input::UINT,
                'cookie_path' => XenForo_Input::STRING,
                'encrypt' => XenForo_Input::UINT
            ));
        
        if ($options['original_server_file']) {
            self::$_fileName = $options['original_server_file'];
        } else {
            if ($options['redirect']) {
                self::$_fileName = $options['redirect'];
            } else {
                self::$_fileName = $options['server_file'];
            }
            $options['original_server_file'] = self::$_fileName;
        }
        
        if ($returnBody) {
            $options['return'] = 'body';
        }
        
        $errorPhraseKey = '';
        $body = $installUpgradeModel->checkForUrl($options, $errorPhraseKey);
        
        $this->_controller->getRequest()->setParams($options);
        
        if ($errorPhraseKey) {
            if ($errorPhraseKey == 'do_not_have_permission') {
                $viewParams = $options;
                $viewParams['canEncrypt'] = $installUpgradeModel->canEncrypt();
                throw $this->_controller->responseException(
                    $this->_controller->responseNoPermissionExternal($viewParams));
            } else {
                throw $this->_controller->responseException(
                    $this->_controller->responseError(new XenForo_Phrase($errorPhraseKey)));
            }
        }
        
        return $body;
    }

    public function checkForDirectory()
    {
        $input = $this->_controller->getInput();
        
        $serverFile = $input->filterSingle('server_file', XenForo_Input::STRING);
        
        if (is_dir($serverFile)) {
            throw $this->_controller->responseException(
                $this->_controller->responseRedirect(XenForo_ControllerResponse_Redirect::SUCCESS, 
                    XenForo_Link::buildAdminLink('add-ons/install-multiple', '', 
                        array(
                            'server_file' => $serverFile
                        ))));
        }
    }

    public static function getFileName()
    {
        return self::$_fileName;
    }

    public static function setFileName($fileName)
    {
        self::$_fileName = $fileName;
    }
}