<?php

class Waindigo_InstallUpgrade_ControllerAdmin_Upgrade extends XenForo_ControllerAdmin_Abstract
{

    protected $_unsupportedString = ' (Unsupported)';

    protected function _preDispatch($action)
    {
        parent::_preDispatch($action);

        $this->_request->setParam('cookie_path', '/customers/');
    }

    public function actionIndex()
    {
        $rebuild = $this->_input->filterSingle('rebuild', XenForo_Input::UINT);

        $xenOptions = XenForo_Application::get('options');

        $licenseKey = $xenOptions->waindigo_installUpgrade_licenseKey;

        if (!$licenseKey) {
            return $this->responseRedirect(XenForo_ControllerResponse_Redirect::SUCCESS,
                XenForo_Link::buildAdminLink('upgrade/get-license-key', '',
                    array(
                        'rebuild' => $rebuild
                    )));
        }

        $licenseValidationToken = $xenOptions->waindigo_installUpgrade_licenseValidationToken;

        if (!$licenseValidationToken) {
            return $this->responseRedirect(XenForo_ControllerResponse_Redirect::SUCCESS,
                XenForo_Link::buildAdminLink('upgrade/get-validation-token', '',
                    array(
                        'rebuild' => $rebuild
                    )));
        }

        $installUpgradeModel = $this->_getInstallUpgradeModel();

        if (!$installUpgradeModel->validateLicenseToken($licenseValidationToken) &&
             !$xenOptions->waindigo_installUpgrade_bypassLicenseCheck) {
            $dw = XenForo_DataWriter::create('XenForo_DataWriter_Option');
            $dw->setExistingData('waindigo_installUpgrade_licenseKey');
            $dw->set('option_value', '');
            $dw->save();
            XenForo_Application::get('options')->set('waindigo_installUpgrade_licenseKey', $licenseKey);

            $dw = XenForo_DataWriter::create('XenForo_DataWriter_Option');
            $dw->setExistingData('waindigo_installUpgrade_licenseValidationToken');
            $dw->set('option_value', '');
            $dw->save();
            XenForo_Application::get('options')->set('waindigo_installUpgrade_licenseValidationToken',
                $licenseValidationToken);

            return $this->responseView('Waindigo_InstallUpgrade_ViewAdmin_Upgrade_InvalidToken',
                'waindigo_invalid_token_installupgrade');
        }

        $fileName = $this->_input->filterSingle('server_file', XenForo_Input::STRING);
        if (!$fileName) {
            $this->_request->setParam('server_file', 'https://xenforo.com/customers/download');
        }

        $downloadVersionId = $this->_input->filterSingle('download_version_id', XenForo_Input::UINT);

        if ((!$fileName || filter_var($fileName, FILTER_VALIDATE_URL) !== false) && !$downloadVersionId) {
            return $this->responseRedirect(XenForo_ControllerResponse_Redirect::SUCCESS,
                XenForo_Link::buildAdminLink('upgrade/get-download-version', '',
                    array(
                        'rebuild' => $rebuild
                    )));
        }

        $postParams = array(
            'l' => $licenseKey,
            'd' => 'xenforo',
            'agree' => 1,
            'download_version_id' => $downloadVersionId,
            'options' => array(
                'upgradePackage' => 1
            )
        );

        $this->_request->setParam('post_params', $postParams);

        /*
         * @var $helper Waindigo_InstallUpgrade_ControllerHelper_InstallUpgrade
         */
        $helper = $this->getHelper('Waindigo_InstallUpgrade_ControllerHelper_InstallUpgrade');
        $helper->checkForUrl();

        $newFileName = $this->_input->filterSingle('server_file', XenForo_Input::STRING);
        if ($newFileName != $fileName) {
            return $this->responseRedirect(XenForo_ControllerResponse_Redirect::SUCCESS,
                XenForo_Link::buildAdminLink('upgrade', '',
                    array(
                        'server_file' => $newFileName,
                        'rebuild' => $rebuild
                    )));
        }

        $currentVersionId = XenForo_Application::get('options')->currentVersionId;

        $fileName = $installUpgradeModel->extractFromFile($fileName);

        if ($currentVersionId < XenForo_Application::$versionId) {
            $skippedFiles = $installUpgradeModel->getSkippedFiles();
            if (!empty($skippedFiles)) {
                $viewParams['skippedFiles'] = $skippedFiles;
                try {
                    return $this->responseView('Waindigo_InstallUpgrade_ViewPublic_AddOn_FilesSkipped',
                        'waindigo_files_skipped_addon_installupgrade', $viewParams);
                } catch (Exception $e) {
                    echo 'Permissions error. Please upload files manually.';
                    exit();
                }
            }
        }

        if ($rebuild && $this->_getUpgradeModel()->getLatestUpgradeVersionId() === XenForo_Application::$versionId &&
             XenForo_Application::get('options')->currentVersionId >= XenForo_Application::$versionId) {
            header('Location: install/index.php?upgrade/rebuild');
        } else {
            header('Location: install/index.php?upgrade');
        }
        exit();
    }

    public function actionRebuild()
    {
        return $this->responseRedirect(XenForo_ControllerResponse_Redirect::RESOURCE_CANONICAL_PERMANENT,
            XenForo_Link::buildAdminLink('upgrade', '', array(
                'rebuild' => 1
            )));
    }

    public function actionGetLicenseKey()
    {
        $rebuild = $this->_input->filterSingle('rebuild', XenForo_Input::UINT);

        $licenseKey = $this->_input->filterSingle('license_key', XenForo_Input::STRING);

        if ($licenseKey) {
            $dw = XenForo_DataWriter::create('XenForo_DataWriter_Option');
            $dw->setExistingData('waindigo_installUpgrade_licenseKey');
            $dw->set('option_value', $licenseKey);
            $dw->save();
            XenForo_Application::get('options')->set('waindigo_installUpgrade_licenseKey', $licenseKey);

            return $this->responseReroute(__CLASS__, 'index');
        }

        $fileName = $this->_input->filterSingle('server_file', XenForo_Input::STRING);
        if (!$fileName) {
            $this->_request->setParam('server_file', 'https://xenforo.com/customers/');
        }

        /*
         * @var $helper Waindigo_InstallUpgrade_ControllerHelper_InstallUpgrade
         */
        $helper = $this->getHelper('Waindigo_InstallUpgrade_ControllerHelper_InstallUpgrade');
        $body = $helper->checkForUrl(true);

        $pattern = '#<li class="license[^"]*">.*<h2 class="title">\s*XenForo\s*\(<a href="([^"]*)" target="_blank" class="minor">([^<]*)<.*<ul class="downloadLinks">\s*<li class="downloadLink"><a href="customers/download\?l=([A-F0-9]*)&#Us';
        preg_match_all($pattern, $body, $matches);

        $licenses = array();
        if (!empty($matches[0])) {
            foreach ($matches[0] as $key => $matched) {
                $licenses[$matches[3][$key]] = array(
                    'title' => $matches[2][$key],
                    'selected' => $this->_isHostMatch($matches[1][$key])
                );
            }
        }

        $viewParams = array(
            'licenses' => $licenses,
            'rebuild' => $rebuild
        );

        return $this->responseView('Waindigo_InstallUpgrade_ViewAdmin_Upgrade_GetLicenseKey',
            'waindigo_get_license_key_installupgrade', $viewParams);
    }

    public function actionGetValidationToken()
    {
        $rebuild = $this->_input->filterSingle('rebuild', XenForo_Input::UINT);

        $validationToken = $this->_input->filterSingle('validation_token', XenForo_Input::STRING);

        if ($validationToken) {
            $dw = XenForo_DataWriter::create('XenForo_DataWriter_Option');
            $dw->setExistingData('waindigo_installUpgrade_licenseValidationToken');
            $dw->set('option_value', $validationToken);
            $dw->save();
            XenForo_Application::get('options')->set('waindigo_installUpgrade_licenseValidationToken', $validationToken);

            return $this->responseReroute(__CLASS__, 'index');
        }

        $oldFileName = $this->_input->filterSingle('server_file', XenForo_Input::STRING);

        $licenseKey = XenForo_Application::get('options')->waindigo_installUpgrade_licenseKey;

        if (!$licenseKey) {
            return $this->responseRedirect(XenForo_ControllerResponse_Redirect::SUCCESS,
                XenForo_Link::buildAdminLink('upgrade/get-license-key', '',
                    array(
                        'rebuild' => $rebuild
                    )));
        }

        $this->_request->setParam('server_file', 'https://xenforo.com/customers/validation-token?l=' . $licenseKey);

        /*
         * @var $helper Waindigo_InstallUpgrade_ControllerHelper_InstallUpgrade
         */
        $helper = $this->getHelper('Waindigo_InstallUpgrade_ControllerHelper_InstallUpgrade');
        $body = $helper->checkForUrl(true);

        $pattern = '#<p style="font-size: 150%; font-weight: bold; margin: -0.5em 0 0.5em; text-align: center">(.*)</p>#Us';
        preg_match($pattern, $body, $matches);

        if (!empty($matches[1])) {
            $validationToken = $matches[1];

            $dw = XenForo_DataWriter::create('XenForo_DataWriter_Option');
            $dw->setExistingData('waindigo_installUpgrade_licenseValidationToken');
            $dw->set('option_value', $validationToken);
            $dw->save();
            XenForo_Application::get('options')->set('waindigo_installUpgrade_licenseValidationToken', $validationToken);

            return $this->responseReroute(__CLASS__, 'index');
        }

        return $this->responseView('Waindigo_InstallUpgrade_ViewAdmin_Upgrade_NoTokenFound',
            'waindigo_no_token_found_installupgrade');
    }

    public function actionGetDownloadVersion()
    {
        $rebuild = $this->_input->filterSingle('rebuild', XenForo_Input::UINT);

        $licenseKey = XenForo_Application::get('options')->waindigo_installUpgrade_licenseKey;

        if (!$licenseKey) {
            return $this->responseRedirect(XenForo_ControllerResponse_Redirect::SUCCESS,
                XenForo_Link::buildAdminLink('upgrade/get-license-key', '',
                    array(
                        'rebuild' => $rebuild
                    )));
        }

        $downloadVersionId = $this->_input->filterSingle('download_version_id', XenForo_Input::UINT);

        $fileName = $this->_input->filterSingle('server_file', XenForo_Input::STRING);
        if (!$fileName) {
            $this->_request->setParam('server_file',
                'https://xenforo.com/customers/download?l=' . $licenseKey . '&d=xenforo');
        }

        /*
         * @var $helper Waindigo_InstallUpgrade_ControllerHelper_InstallUpgrade
         */
        $helper = $this->getHelper('Waindigo_InstallUpgrade_ControllerHelper_InstallUpgrade');
        $body = $helper->checkForUrl(true);

        $pattern = '#<select name="download_version_id" class="textCtrl">\s*((?:<option value="[0-9]*" (?:selected="selected")?>[^<]*</option>\s*)+)</select>#Us';
        preg_match($pattern, $body, $matches);

        $allowUnsupported = XenForo_Application::get('options')->waindigo_installUpgrade_allowUnsupported;

        $versions = array();
        if (isset($matches[1])) {
            $optionBody = $matches[1];
            $pattern = '#<option value="([0-9]*)" (selected="selected")?>([^<]*)</option>#Us';
            preg_match_all($pattern, $optionBody, $optionMatches);
            if (!empty($optionMatches[0])) {
                $breakNext = false;
                foreach ($optionMatches[0] as $key => $matched) {
                    $versionString = $optionMatches[3][$key];
                    if (strpos($versionString, $this->_unsupportedString) !== false) {
                        $versionString = substr($versionString, 0,
                            strlen($versionString) - strlen($this->_unsupportedString));
                        $isUnsupported = true;
                    } else {
                        $isUnsupported = false;
                    }
                    if ($breakNext) {
                        break;
                    }
                    if ($versionString == XenForo_Application::$version) {
                        if ($rebuild) {
                            $breakNext = true;
                        } else {
                            break;
                        }
                    }
                    if (strpos($versionString, ' ') !== false) {
                        $versionString = substr($versionString, 0, strpos($versionString, ' '));
                    }
                    if (strpos(XenForo_Application::$version, ' ') !== false) {
                        $currentVersion = substr(XenForo_Application::$version, 0,
                            strpos(XenForo_Application::$version, ' '));
                    } else {
                        $currentVersion = XenForo_Application::$version;
                    }

                    if ($versionString == $currentVersion) {
                        $breakNext = true;
                    }

                    if ($isUnsupported && !$allowUnsupported) {
                        continue;
                    }

                    if ($downloadVersionId && $downloadVersionId != $optionMatches[1][$key]) {
                        continue;
                    }

                    $versions[$optionMatches[1][$key]] = array(
                        'download_version_id' => $optionMatches[1][$key],
                        'title' => $optionMatches[3][$key],
                        'selected' => $optionMatches[2][$key] ? true : false
                    );
                }
            }
        }

        if (count($versions) == 1) {
            $version = reset($versions);
            $this->_request->setParam('download_version_id', $version['download_version_id']);
            return $this->responseReroute(__CLASS__, 'index');
        }

        $viewParams = array(
            'versions' => $versions,
            'rebuild' => $rebuild
        );

        return $this->responseView('Waindigo_InstallUpgrade_ViewAdmin_Upgrade_GetDownloadVersion',
            'waindigo_get_download_version_installupgrade', $viewParams);
    }

    protected function _isHostMatch($url)
    {
        $homePageUrl = XenForo_Application::get('options')->homePageUrl;
        $boardUrl = XenForo_Application::get('options')->boardUrl;

        $hosts = array(
            parse_url($homePageUrl, PHP_URL_HOST),
            parse_url($boardUrl, PHP_URL_HOST),
            $_SERVER['SERVER_NAME']
        );

        $urlHost = parse_url($url, PHP_URL_HOST);

        foreach ($hosts as $host) {
            if (strpos($host, $urlHost) !== false || strpos($urlHost, $host) !== false) {
                return true;
            }
        }
    }

    public function responseNoPermissionExternal(array $viewParams = array())
    {
        return $this->responseView('Waindigo_InstallUpgrade_ViewAdmin_Upgrade_Login',
            'waindigo_upgrade_login_installupgrade', $viewParams);
    }

    /**
     * Searches for a filename by the left-most prefix of a name (for
     * auto-complete).
     *
     * @return XenForo_ControllerResponse_Abstract
     */
    public function actionSearchFilename()
    {
        $q = ltrim(
            $this->_input->filterSingle('q', XenForo_Input::STRING,
                array(
                    'noTrim' => true
                )));

        $results = array();

        if ($q !== '') {
            if (is_dir($q)) {
                $path = $q;
                $q = '';
            } else {
                $pathInfo = pathinfo($q);
                if (is_dir($pathInfo['dirname'])) {
                    $path = $pathInfo['dirname'];
                    $q = $pathInfo['basename'];
                } else {
                    $path = '';
                }
            }

            if ($path) {
                if ($path == '.') {
                    $path = '';
                } else {
                    $path = rtrim($path, '/\\') . DIRECTORY_SEPARATOR;
                }

                $dir = XenForo_Application::getInstance()->getRootDir() . DIRECTORY_SEPARATOR . $path;

                $handle = opendir($dir);

                $possibleExtensions = array(
                    'kml',
                    'rar',
                    'xml',
                    'zip'
                );

                while (false !== ($file = readdir($handle))) {
                    if ($file != "." && $file != "..") {
                        $pathInfo = pathinfo($file);
                        $result = '';
                        if (!$q) {
                            $result = $path . $file;
                        } elseif (preg_match('#^(' . preg_quote($q) . ')#i', $file)) {
                            $result = $path . $file;
                        }
                        if ($result && (empty($pathInfo['extension']) || in_array(strtolower($pathInfo['extension']),
                            $possibleExtensions))) {
                            $results[] = $result;
                        }
                    }
                    if (count($results) >= 5) {
                        break;
                    }
                }

                if (count($results) == 1) {
                    $result = reset($results) . DIRECTORY_SEPARATOR;

                    $dir = XenForo_Application::getInstance()->getRootDir() . DIRECTORY_SEPARATOR . $result;

                    if (is_dir($dir)) {
                        $handle = opendir($dir);

                        while (false !== ($file = readdir($handle))) {
                            if ($file != "." && $file != "..") {
                                $pathInfo = pathinfo($file);
                                if (empty($pathInfo['extension']) || in_array(strtolower($pathInfo['extension']),
                                    $possibleExtensions)) {
                                    $results[] = $result . $file;
                                }
                            }
                            if (count($results) >= 5) {
                                break;
                            }
                        }
                    }
                }
            }
        }

        $viewParams = array(
            'results' => $results
        );

        return $this->responseView('Waindigo_InstallUpgrade_ViewAdmin_SearchFilename', '', $viewParams);
    }

    /**
     *
     * @return Waindigo_InstallUpgrade_Model_InstallUpgrade
     */
    protected function _getInstallUpgradeModel()
    {
        return $this->getModelFromCache('Waindigo_InstallUpgrade_Model_InstallUpgrade');
    }

    /**
     *
     * @return XenForo_Install_Model_Upgrade
     */
    protected function _getUpgradeModel()
    {
        return $this->getModelFromCache('XenForo_Install_Model_Upgrade');
    }
}