<?php

/**
 * BB code formatter that follows the formatting of the text as plain text.
 *
 * @package XenForo_BbCode
 */
class Waindigo_InstallUpgrade_BbCode_Formatter_Broadcast extends XenForo_BbCode_Formatter_Base
{

    /**
     * Gets the list of valid BB code tags.
     * This removes most behaviors.
     *
     * @see XenForo_BbCode_Formatter_Base::getTags()
     */
    public function getTags()
    {
        if ($this->_tags !== null) {
            return $this->_tags;
        }
        
        $callback = array(
            $this,
            'handleTag'
        );
        
        $tags = parent::getTags();
        foreach ($tags as $tagName => &$tag) {
            if ($tagName == 'url') {
                continue;
            }
            unset($tag['replace'], $tag['callback']);
            $tag['callback'] = $callback;
        }
        
        return $tags;
    }

    public function handleTag(array $tag, array $rendererStates)
    {
        $tagName = $tag['tag'];
        
        return $this->renderSubTree($tag['children'], $rendererStates);
    }
}