<?php

/**
 *
 * @see XenForo_DataWriter_UserField
 */
class Waindigo_MultipleChoice_Extend_XenForo_DataWriter_UserField extends XFCP_Waindigo_MultipleChoice_Extend_XenForo_DataWriter_UserField
{

    /**
     *
     * @see XenForo_DataWriter_UserField::_getFields()
     */
    protected function _getFields()
    {
        $fields = parent::_getFields();

        $fields['xf_user_field']['multiple_choice_waindigo'] = array(
            'type' => self::TYPE_UINT,
            'default' => 0
        );

        return $fields;
    } /* END _getFields */

    /**
     *
     * @see XenForo_DataWriter_UserField::_preSave()
     */
    protected function _preSave()
    {
        if (!empty($GLOBALS['XenForo_ControllerAdmin_UserField'])) {
            /* @var $controller XenForo_ControllerAdmin_UserField */
            $controller = $GLOBALS['XenForo_ControllerAdmin_UserField'];

            $input = $controller->getInput()->filter(
                array(
                    'multiple_choice_waindigo' => XenForo_Input::BOOLEAN,
                    'multiple_choice_waindigo_set' => XenForo_Input::BOOLEAN
                ));

            if (in_array($this->get('field_type'), array(
                'select',
                'multiselect'
            ))) {
                if ($input['multiple_choice_waindigo_set']) {
                    $this->set('multiple_choice_waindigo', $input['multiple_choice_waindigo']);
                }
            } else {
                $this->set('multiple_choice_waindigo', 0);
            }
        }

        parent::_preSave();
    } /* END _preSave */
}