<?php

/**
 *
 * @see Waindigo_CustomPostFields_DataWriter_PostField
 */
class Waindigo_MultipleChoice_Extend_Waindigo_CustomPostFields_DataWriter_PostField extends XFCP_Waindigo_MultipleChoice_Extend_Waindigo_CustomPostFields_DataWriter_PostField
{

    /**
     *
     * @see Waindigo_CustomPostFields_DataWriter_PostField
     */
    protected function _getFields()
    {
        $fields = parent::_getFields();

        $fields['xf_post_field']['multiple_choice_waindigo'] = array(
            'type' => self::TYPE_UINT,
            'default' => 0
        );

        return $fields;
    } /* END _getFields */

    /**
     *
     * @see Waindigo_CustomPostFields_DataWriter_PostField
     */
    protected function _preSave()
    {
        if (!empty($GLOBALS['Waindigo_CustomPostFields_ControllerAdmin_PostField'])) {
            /* @var $controller Waindigo_CustomPostFields_ControllerAdmin_PostField */
            $controller = $GLOBALS['Waindigo_CustomPostFields_ControllerAdmin_PostField'];

            $input = $controller->getInput()->filter(
                array(
                    'multiple_choice_waindigo' => XenForo_Input::BOOLEAN,
                    'multiple_choice_waindigo_set' => XenForo_Input::BOOLEAN
                ));

            if (in_array($this->get('field_type'), array(
                'select',
                'multiselect'
            ))) {
                if ($input['multiple_choice_waindigo_set']) {
                    $this->set('multiple_choice_waindigo', $input['multiple_choice_waindigo']);
                }
            } else {
                $this->set('multiple_choice_waindigo', 0);
            }
        }

        parent::_preSave();
    } /* END _preSave */
}