<?php

/**
 *
 * @see Waindigo_CustomFields_DataWriter_SocialForumField
 */
class Waindigo_MultipleChoice_Extend_Waindigo_CustomFields_DataWriter_SocialForumField extends XFCP_Waindigo_MultipleChoice_Extend_Waindigo_CustomFields_DataWriter_SocialForumField
{

    /**
     *
     * @see Waindigo_CustomFields_DataWriter_SocialForumField
     */
    protected function _getFields()
    {
        $fields = parent::_getFields();

        $fields['xf_social_forum_field']['multiple_choice_waindigo'] = array(
            'type' => self::TYPE_UINT,
            'default' => 0
        );

        return $fields;
    } /* END _getFields */

    /**
     *
     * @see Waindigo_CustomFields_DataWriter_SocialForumField
     */
    protected function _preSave()
    {
        if (!empty($GLOBALS['Waindigo_CustomFields_ControllerAdmin_SocialForumField'])) {
            /* @var $controller Waindigo_CustomFields_ControllerAdmin_SocialForumField */
            $controller = $GLOBALS['Waindigo_CustomFields_ControllerAdmin_SocialForumField'];

            $input = $controller->getInput()->filter(
                array(
                    'multiple_choice_waindigo' => XenForo_Input::BOOLEAN,
                    'multiple_choice_waindigo_set' => XenForo_Input::BOOLEAN
                ));

            if (in_array($this->get('field_type'), array(
                'select',
                'multiselect'
            ))) {
                if ($input['multiple_choice_waindigo_set']) {
                    $this->set('multiple_choice_waindigo', $input['multiple_choice_waindigo']);
                }
            } else {
                $this->set('multiple_choice_waindigo', 0);
            }
        }

        parent::_preSave();
    } /* END _preSave */
}