<?php

class Waindigo_InfusionsoftApi_Option_ContactGroups
{

    /**
     * Renders the contact groups option.
     *
     * @param XenForo_View $view View object
     * @param string $fieldPrefix Prefix for the HTML form field name
     * @param array $preparedOption Prepared option info
     * @param boolean $canEdit True if an "edit" link should appear
     *
     * @return XenForo_Template_Abstract Template object
     */
    public static function renderOption(XenForo_View $view, $fieldPrefix, array $preparedOption, $canEdit)
    {
        /* @var $contactGroupCategoryDataModel Waindigo_InfusionsoftApi_Model_InfusionsoftApi_DataService_ContactGroupCategory */
        $contactGroupCategoryDataModel = XenForo_Model::create(
            'Waindigo_InfusionsoftApi_Model_InfusionsoftApi_DataService_ContactGroupCategory');

        $contactGroupCategories = $contactGroupCategoryDataModel->getContactGroupCategories();

        $contactGroupCategoryIds = XenForo_Application::arrayColumn($contactGroupCategories, 'Id');

        /* @var $contactGroupDataModel Waindigo_InfusionsoftApi_Model_InfusionsoftApi_DataService_ContactGroup */
        $contactGroupDataModel = XenForo_Model::create(
            'Waindigo_InfusionsoftApi_Model_InfusionsoftApi_DataService_ContactGroup');

        $contactGroups = $contactGroupDataModel->getContactGroupsForCategory($contactGroupCategoryIds);

        foreach ($contactGroups as $contactGroupId => $contactGroup) {
            $contactGroupCategories[$contactGroup['GroupCategoryId']]['groups'][$contactGroupId] = $contactGroup;
        }

        $preparedOption['contactGroupCategories'] = $contactGroupCategories;

        return XenForo_ViewAdmin_Helper_Option::renderOptionTemplateInternal(
            'waindigo_option_template_tags_infusionsoftapi', $view, $fieldPrefix, $preparedOption, $canEdit);
    }
}