<?php

class Waindigo_InfusionsoftApi_Listener_LoadClass extends Waindigo_Listener_LoadClass
{

    protected function _getExtendedClasses()
    {
        return array(
            'Waindigo_InfusionsoftApi' => array(
                'datawriter' => array(
                    'XenForo_DataWriter_User',
                    'XenForo_DataWriter_UserUpgrade',
                    'Waindigo_Invoices_DataWriter_Invoice'
                ), 
                'controller' => array(
                    'XenForo_ControllerPublic_Account',
                    'Waindigo_Invoices_ControllerAdmin_Invoice',
                    'XenForo_ControllerAdmin_User'
                ), 
                'helper' => array(
                    'XenForo_ControllerHelper_Account'
                ), 
                'model' => array(
                    'XenForo_Model_UserUpgrade',
                    'XenForo_Model_User',
                    'Waindigo_Invoices_Model_Invoice'
                ), 
                'installer_waindigo' => array(
                    'Waindigo_Invoices_Install_Controller'
                ), 
            ), 
        );
    }

    public static function loadClassDataWriter($class, array &$extend)
    {
        $extend = self::createAndRun('Waindigo_InfusionsoftApi_Listener_LoadClass', $class, $extend, 'datawriter');
    }

    public static function loadClassController($class, array &$extend)
    {
        $extend = self::createAndRun('Waindigo_InfusionsoftApi_Listener_LoadClass', $class, $extend, 'controller');
    }

    public static function loadClassHelper($class, array &$extend)
    {
        $extend = self::createAndRun('Waindigo_InfusionsoftApi_Listener_LoadClass', $class, $extend, 'helper');
    }

    public static function loadClassModel($class, array &$extend)
    {
        $extend = self::createAndRun('Waindigo_InfusionsoftApi_Listener_LoadClass', $class, $extend, 'model');
    }

    public static function loadClassInstallerWaindigo($class, array &$extend)
    {
        $extend = self::createAndRun('Waindigo_InfusionsoftApi_Listener_LoadClass', $class, $extend, 'installer_waindigo');
    }
}