<?php

/**
 *
 * @see XenForo_DataWriter_UserUpgrade
 */
class Waindigo_InfusionsoftApi_Extend_XenForo_DataWriter_UserUpgrade extends XFCP_Waindigo_InfusionsoftApi_Extend_XenForo_DataWriter_UserUpgrade
{

    /**
     *
     * @see XenForo_DataWriter_User::_getFields()
     */
    protected function _getFields()
    {
        $fields = parent::_getFields();

        $fields['xf_user_upgrade']['infusionsoft_product_id_waindigo'] = array(
            'type' => self::TYPE_UINT,
            'default' => 0
        );

        return $fields;
    }

    /**
     *
     * @see XenForo_DataWriter_UserUpgrade::_postSave()
     */
    protected function _postSave()
    {
        $db = $this->_db;

        if ($this->isInsert() && !$this->get('infusionsoft_product_id_waindigo')) {
            $product = array(
                'ProductName' => $this->get('title'),
                'ProductPrice' => $this->get('cost_amount'),
                'HideInStore' => true,
                'Status' => true
            );

            /* @var $productDw Waindigo_InfusionsoftApi_DataWriter_InfusionsoftApi_Product */
            $productDw = XenForo_DataWriter::create('Waindigo_InfusionsoftApi_DataWriter_InfusionsoftApi_Product',
                XenForo_DataWriter::ERROR_SILENT);
            $productDw->bulkSet($product);
            $productDw->save();

            $productId = $productDw->get('Id');

            $this->_setPostSave('infusionsoft_product_id_waindigo', $productId);
            $db->update('xf_user_upgrade',
                array(
                    'infusionsoft_product_id_waindigo' => $productId
                ), 'user_upgrade_id = ' . $db->quote($this->get('user_upgrade_id')));
        }

        parent::_postSave();
    }
}