<?php

/**
 *
 * @see XenForo_DataWriter_User
 */
class Waindigo_InfusionsoftApi_Extend_XenForo_DataWriter_User extends XFCP_Waindigo_InfusionsoftApi_Extend_XenForo_DataWriter_User
{

    const OPTION_INFUSIONSOFT_API_IMPORT = 'infusionsoftApiImport';

    /**
     *
     * @see XenForo_DataWriter_User::_getFields()
     */
    protected function _getFields()
    {
        $fields = parent::_getFields();

        $fields['xf_user_profile']['infusionsoft_contact_id_waindigo'] = array(
            'type' => self::TYPE_UINT,
            'default' => 0
        );

        $fields['xf_user_profile']['infusionsoft_last_updated_waindigo'] = array(
            'type' => self::TYPE_UINT,
            'default' => 0
        );

        $fields['xf_user_profile']['infusionsoft_contact_group_ids_waindigo'] = array(
            'type' => self::TYPE_STRING,
            'default' => ''
        );

        return $fields;
    }

    /**
     *
     * @see XenForo_DataWriter_User::_getDefaultOptions()
     */
    protected function _getDefaultOptions()
    {
        $defaultOptions = parent::_getDefaultOptions();

        $defaultOptions[self::OPTION_INFUSIONSOFT_API_IMPORT] = false;

        return $defaultOptions;
    }

    /**
     *
     * @see XenForo_DataWriter_User::_verifyEmail()
     */
    protected function _verifyEmail(&$email)
    {
        if ($this->getOption(self::OPTION_INFUSIONSOFT_API_IMPORT) && $email === '') {
            return true;
        }

        return parent::_verifyEmail($email);
    }

    protected function _preSave()
    {
        if (!empty($GLOBALS['XenForo_ControllerAdmin_User'])) {
            /* @var $controller XenForo_ControllerAdmin_User */
            $controller = $GLOBALS['XenForo_ControllerAdmin_User'];

            $input = $controller->getInput()->filter(
                array(
                    'infusionsoft_contact_id_waindigo' => XenForo_Input::UINT,
                    'infusionsoft_contact_id_waindigo_shown' => XenForo_Input::UINT
                ));

            if ($input['infusionsoft_contact_id_waindigo_shown']) {
                $this->set('infusionsoft_contact_id_waindigo', $input['infusionsoft_contact_id_waindigo']);
                $this->set('infusionsoft_last_updated_waindigo', 0);
                $this->set('infusionsoft_contact_group_ids_waindigo', '');
            }
        }

        parent::_preSave();
    }

    /**
     *
     * @see XenForo_DataWriter_User::_postSave()
     */
    protected function _postSave()
    {
        $db = $this->_db;

        $xenOptions = XenForo_Application::get('options');

        /* @var $contactServiceModel Waindigo_InfusionsoftApi_Model_InfusionsoftApi_ContactService */
        $contactServiceModel = XenForo_Model::create('Waindigo_InfusionsoftApi_Model_InfusionsoftApi_ContactService');

        if ($this->isInsert() && !$this->get('infusionsoft_contact_id_waindigo')) {
            $contact = array(
                'FirstName' => (string) $this->get('username'),
                'Username' => (string) $this->get('username'),
                'Email' => (string) $this->get('email')
            );

            $contact = $contactServiceModel->getDataFieldsFromUserDw($contact, $this);

            $contactId = $contactServiceModel->addContact($contact);

            $this->_setPostSave('infusionsoft_contact_id_waindigo', $contactId);
            $db->update('xf_user_profile',
                array(
                    'infusionsoft_contact_id_waindigo' => $contactId
                ), 'user_id = ' . $db->quote($this->get('user_id')));
        }

        if ($this->isUpdate() && $this->get('infusionsoft_contact_id_waindigo')) {
            $contactId = $this->get('infusionsoft_contact_id_waindigo');

            $contact = array();

            if ($this->isChanged('infusionsoft_contact_id_waindigo') || $this->isChanged('username')) {
                if (empty($xenOptions->waindigo_infusionsoftApi_formFields['custom_field_First_Name'])) {
                    $contact['FirstName'] = (string) $this->get('username');
                }
                $contact['Username'] = (string) $this->get('username');
            }

            if ($this->isChanged('infusionsoft_contact_id_waindigo') || $this->isChanged('email')) {
                $contact['Email'] = (string) $this->get('email');
            }

            $contact = $contactServiceModel->getDataFieldsFromUserDw($contact, $this,
                !$this->isChanged('infusionsoft_contact_id_waindigo'));

            if ($contact) {
                $contactId = $contactServiceModel->updateContact($contactId, $contact);
                if ($contactId != $this->get('infusionsoft_contact_id_waindigo')) {
                    $contactServiceModel->updateUserContactId($this->getMergedData(), $contactId);
                    $this->_setPostSave('infusionsoft_contact_id_waindigo', $contactId);
                }
            }
        }

        parent::_postSave();
    }

    public function getUpdatedCustomFields()
    {
        return $this->_updateCustomFields;
    }

    protected function _postDelete()
    {
        $xenOptions = XenForo_Application::get('options');

        if ($this->get('infusionsoft_contact_id_waindigo') && $xenOptions->waindigo_infusionsoftApi_deleteContacts) {
            /* @var $contactServiceModel Waindigo_InfusionsoftApi_Model_InfusionsoftApi_ContactService */
            $contactServiceModel = XenForo_Model::create(
                'Waindigo_InfusionsoftApi_Model_InfusionsoftApi_ContactService');

            $contactServiceModel->deleteContact($this->get('infusionsoft_contact_id_waindigo'));
        }

        parent::_postDelete();
    }
}