<?php

/**
 *
 * @see Waindigo_Invoices_DataWriter_Invoice
 */
class Waindigo_InfusionsoftApi_Extend_Waindigo_Invoices_DataWriter_Invoice extends XFCP_Waindigo_InfusionsoftApi_Extend_Waindigo_Invoices_DataWriter_Invoice
{

    /**
     *
     * @see Waindigo_Invoices_DataWriter_Invoice::_getFields()
     */
    protected function _getFields()
    {
        $fields = parent::_getFields();

        $fields['invoice_waindigo']['infusionsoft_invoice_id_waindigo'] = array(
            'type' => self::TYPE_UINT,
            'default' => 0
        );

        return $fields;
    }

    /**
     *
     * @see Waindigo_Invoices_DataWriter_Invoice::_postSave()
     */
    protected function _postSave()
    {
        $db = $this->_db;

        if ($this->isInsert() && !$this->get('infusionsoft_invoice_id_waindigo')) {
            /* @var $invoiceServiceModel Waindigo_InfusionsoftApi_Model_InfusionsoftApi_InvoiceService */
            $invoiceServiceModel = $this->getModelFromCache('Waindigo_InfusionsoftApi_Model_InfusionsoftApi_InvoiceService');

            $invoiceServiceModel->pushInvoice($this->get('invoice_id'));
        }

        parent::_postSave();
    }
}