<?php

class Tapatalk_Listener_TemplatePostRender
{
    public static function template_post_render($templateName, &$output, array &$containerData, XenForo_Template_Abstract $template) {
        if($templateName == 'online_list')
        {
            $memberListItems = preg_split('/<li class="primaryContent memberListItem">/', $output);
            if(!empty($memberListItems))
            {
                $tapatalk_dir_name = XenForo_Application::get('options')->tp_directory;
                if (empty($tapatalk_dir_name)) $tapatalk_dir_name = 'mobiquo';
                foreach($memberListItems as $key => $memberItem)
                {
                    if(preg_match('/\[On Tapatalk\]/', $memberItem))
                    {
                        $memberItem = preg_replace('/\[On Tapatalk\]/', '', $memberItem);
                        $memberItem = preg_replace('/<div class="extra">/', '<div class="extra">
            <img src="'.$tapatalk_dir_name.'/forum_icons/tapatalk-online.png">', $memberItem);
                    }
                    else if(preg_match('/\[On BYO\]/', $memberItem))
                    {
                        $memberItem = preg_replace('/\[On BYO\]/', '', $memberItem);
                        $memberItem = preg_replace('/<div class="extra">/', '<div class="extra">
            <img src="'.$tapatalk_dir_name.'/forum_icons/tapatalk-online.png">', $memberItem);
                    }
                    if($key == 0)
                        $output = $memberItem;
                    else
                        $output .= '<li class="primaryContent memberListItem">'.$memberItem;
                }
            }
        }

        if ($templateName == 'thread_view' || $templateName == 'conversation_view')
        {
            $protocol = (isset($_SERVER['HTTPS']) && trim($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') || (isset($_SERVER['SERVER_PORT']) && $_SERVER['SERVER_PORT'] == 443) ? 'https' : 'http';
            $originalOutput = $output;
            $output = preg_replace('/\[emoji(\d+)\]/i', '<img src="//emoji.tapatalk-cdn.com/emoji\1.png" />', $output);
            $output = preg_replace('/https?:\/\/cloud\.tapatalk\.com/i',  '//cloud.tapatalk.com', $output);
            $output = preg_replace('/https?:\/\/uploads\.tapatalk-cdn\.com/i',  '//uploads.tapatalk-cdn.com', $output);
            $output = preg_replace('/https?:\/\/images\.tapatalk-cdn\.com/i', '//images.tapatalk-cdn.com', $output);
            if(empty($output))
            {
                $output = $originalOutput;
            }
            try
            {
                $options = XenForo_Application::get('options');
                $TT_bannerControlData = isset($options->tapatalk_banner_control) ? $options->tapatalk_banner_control :  array('banner_enable' => -1);
                $TT_bannerControlData = unserialize($TT_bannerControlData);
                if((isset($TT_bannerControlData['file_redirect']) && $TT_bannerControlData['file_redirect'] != 0) || (isset($TT_bannerControlData['image_redirect']) && $TT_bannerControlData['image_redirect'] != 0))
                {
                    $tapatalk_dir_name = XenForo_Application::get('options')->tp_directory;
                    if (empty($tapatalk_dir_name)) $tapatalk_dir_name = 'mobiquo';
                    $options = XenForo_Application::get('options');
                    $boardUrl = $options->boardUrl;
                    $tapatalkPluginUrl = rtrim($boardUrl, '/') . '/' . $tapatalk_dir_name;
                    $TT_bannerControlData = isset($options->tapatalk_banner_control) ? $options->tapatalk_banner_control :  array('banner_enable' => -1);
                    $TT_bannerControlData = unserialize($TT_bannerControlData);
                    $TT_fid = isset($TT_bannerControlData['forum_id']) ? $TT_bannerControlData['forum_id'] : '';
                    $showAndroidIcon = true;
                    $showIOSIcon = true;
                    $androidAppUrl = 'https://play.google.com/store/apps/details?id=com.quoord.tapatalkpro.activity';
                    $iosAppUrl = 'https://itunes.apple.com/us/app/tapatalk-discussions-chat/id307880732?mt=8';
                    $isByo = false;
                    if(isset($TT_bannerControlData['byo_info']) && !empty($TT_bannerControlData['byo_info']))
                    {
                        if(isset($TT_bannerControlData['byo_info']['app_android_id']) && !empty($TT_bannerControlData['byo_info']['app_android_id']))
                        {
                            $isByo = true;
                            $androidAppUrl = "https://tapatalk.com/m/?id=6&app_android_id=" . $TT_bannerControlData['byo_info']['app_android_id'] . "&referer=" . tttpr_get_board_url();
                        }
                        else
                        {
                            $showAndroidIcon = false;
                        }
                        if(isset($TT_bannerControlData['byo_info']['app_ios_id']) && !empty($TT_bannerControlData['byo_info']['app_ios_id']))
                        {
                            $isByo = true;
                            $iosAppUrl = "https://tapatalk.com/m/?id=6&app_ios_id=" . $TT_bannerControlData['byo_info']['app_ios_id'] . "&referer=" . tttpr_get_board_url();
                        }
                        else
                        {
                            $showIOSIcon = false;
                        }
                    }
                    $TT_EmbebedScript = "<script>
                    var TTE_fid = $TT_fid;
                    var TTE_isByo = " . ($isByo ? "1" : "0") . ";
                    var TTE_showAndroidIcon = " . ($showAndroidIcon ? "1" : "0") . ";
                    var TTE_showIOSIcon = " . ($showIOSIcon ? "1" : "0") . ";
                    var TTE_androidAppUrl = " . json_encode($androidAppUrl) . ";
                    var TTE_iosAppUrl = " . json_encode($iosAppUrl) . ";
                    var TTE_tapatalkPluginUrl = " . json_encode($tapatalkPluginUrl) . ";
                    </script>
                    <script src='//media.tapatalk-cdn.com/tapatalk-js/embebed-xenforo.js?s=" . time() . "'></script>
                    ";
                    $output .= $TT_EmbebedScript;
                }
            }
            catch(Exception $ex)
            {}
        }
    }

}
function tttpr_get_board_url(){
    $request = new Zend_Controller_Request_Http();
    $getScheme = $request->getScheme();
    $getHttpHost = $request->getHttpHost();
    $getBasePath = $request->getBasePath();
    if (!empty($getScheme) && !empty($getHttpHost)){
        return $getScheme . '://' . $getHttpHost . $getBasePath;
    } else {
        return XenForo_Application::get('options')->boardUrl;
    }
}