<?php
if (!defined('SCRIPT_ROOT')){
    define('SCRIPT_ROOT', empty($_SERVER['SCRIPT_FILENAME']) ? '../../../' : dirname($_SERVER['SCRIPT_FILENAME']).'/');
}
class Tapatalk_Listener_ControllerPostDispatch{
    public static function postDispatchListener($controller,
    $controllerResponse,$controllerName,$action){

        switch ($action){
            case 'AddReply':
                if(isset($controllerResponse->params))
                {
                    $params = $controllerResponse->params;
                    $post = isset($params['lastPost']) ? $params['lastPost'] : '';
                    $thread = isset($params['thread']) ? $params['thread'] : '';
                }
                break;
            case 'Like':
                if(isset($controllerResponse->params))
                {
                    $params = $controllerResponse->params;
                    if (isset($params['liked']) && $params['liked']){
                        $post = isset($params['post']) ? $params['post'] : '';
                        $thread = isset($params['thread']) ? $params['thread'] : '';
                    }
                }
                break;
            case 'Delete':
                if(isset($controllerResponse->params))
                {
                    $params = $controller->getRequest()->getParams();

                   
                    $ids = array();
                    if (isset($params['post_id']) && $params['post_id']){
                        $action = 'delpost';
                        $ids[] = $params['post_id'];
                        self::doPushDelete($action, $ids);
                        return;
                    }
                    else if(isset($params['thread_id']) && $params['thread_id'])
                    {
                        $action = 'deltopic';
                        $ids[] = $params['thread_id'];
                        self::doPushDelete($action, $ids);
                        return;
                    }
                    else if(isset($params['posts']))
                    {
                        foreach($params['posts'] as $key => $postId)
                        {
                            $ids[] = $postId;
                        }
                        $action = 'delpost';
                        self::doPushDelete($action, $ids);
                        return;
                    }
                    else if(isset($params['threads']))
                    {
                        foreach($params['threads'] as $key => $threadId)
                        {
                            $ids[] = $threadId;
                        }
                        $action = 'deltopic';
                        self::doPushDelete($action, $ids);
                        return;
                    }
                }
                break;
            case 'AddThread':
            case 'Watch':
                if(isset($controllerResponse->redirectTarget))
                {
                    $target = $controllerResponse->redirectTarget;
                    if(strpos($target,'?')!== false)
                    {
                        $url_query = parse_url($target, PHP_URL_QUERY);
                    }
                    else
                    {
                        $url_query = $target;
                    }
                    $split_rs = preg_split('/\//', $url_query);
                    if(!empty($split_rs) && is_array($split_rs))
                    {
                        $location = isset($split_rs[0]) && !empty($split_rs[0])?  $split_rs[0] : '';
                        $title = isset($split_rs[1]) && !empty($split_rs[1])?  $split_rs[1] : '';
                        $other = isset($split_rs[2]) && !empty($split_rs[2])?  $split_rs[2] : '';
                        if ($location == 'threads'){
                            if(preg_match('/\.(\d+)/', $title, $match))
                            {
                                $thread_id = $match[1];
                            } else if (preg_match('/^\d+$/', $title, $match)){
                                $thread_id = $match[0];
                            }
                        }
                    }
                    if (!isset($thread_id) || empty($thread_id)){
                        break;
                    }
                    if ($action == 'Watch'){
                        $threadModel = XenForo_Model::create('XenForo_Model_ThreadWatch');
                        $watch = $threadModel->getUserThreadWatchByThreadIds(XenForo_Visitor::getUserId(), array($thread_id));
                        if (empty($watch)){
                            break;
                        }
                    }
                    $thread_model = XenForo_Model::create('XenForo_Model_Thread');
                    $thread = $thread_model->getThreadById($thread_id);
                    $post_model = XenForo_Model::create('XenForo_Model_Post');
                    $post = $post_model->getLastPostInThread($thread['thread_id']);
                }
                break;
            // xenforo action
            case 'InviteInsert':
                $invited_user_ids = '';
                if (isset($controllerResponse->params) && isset($controllerResponse->params['recipients'])){
                    $recipients = $controllerResponse->params['recipients'];

                    if (isset($_REQUEST['recipients']) && !empty($_REQUEST['recipients'])){
                        $temp = $_REQUEST['recipients'];
                        $temp_arr = explode(',', $temp);
                        foreach ($temp_arr as $invited_user_name){
                            foreach ($recipients as $recipient){
                                if (trim($invited_user_name) == trim($recipient['username'])){
                                    $invited_user_ids .= $recipient['user_id'] . ',';
                                }
                            }
                        }
                    }
                }
                $invited_user_ids = trim($invited_user_ids, ' ,');
                self::doPushConvInvite($action, $invited_user_ids);
                break;
            // tapatalk action
            case 'invite_participant':
                if (isset($_REQUEST['tapatalk_invited_user_ids']) && !empty($_REQUEST['tapatalk_invited_user_ids'])){
                    $invited_user_ids = $_REQUEST['tapatalk_invited_user_ids'];
                    self::doPushConvInvite($action, $invited_user_ids);
                }
                break;
            // xenforo action
            case 'Insert':
            case 'InsertReply':
            // tapatalk action
            case 'new_conversation':
            case 'reply_conversation':
                self::doPushConv($action);
                return;
        }
        if (isset($thread) &&!empty($thread) && isset($post) && !empty($post)) {
            $options = XenForo_Application::get('options');
            if(isset($options->tp_push_key) && !empty($options->tp_push_key))
            {
                $boardurl = XenForo_Application::get('options')->boardUrl;
                $boardurl = urlencode($boardurl);
                if(!class_exists('TapatalkPush'))
                {
                    $tapatalk_dir_name = XenForo_Application::get('options')->tp_directory;
                    if (empty($tapatalk_dir_name)) $tapatalk_dir_name = 'mobiquo';
                    $tapatalk_dir_name = XenForo_Application::getInstance()->getRootDir() . '/' . $tapatalk_dir_name;
                    include_once($tapatalk_dir_name . '/push/TapatalkPush.php');
                }
                $TapatalkPush = new TapatalkPush($options->tp_push_key, $boardurl);
                $TapatalkPush->processPush($action, $post, $thread);
            }
            /*
            XenForo_Application::autoload('Tapatalk_Push_Push');
            Tapatalk_Push_Push::tapatalk_push_reply($action, $post, $thread);
            */
        }
    }
    public static function doPushDelete($action, $ids)
    {
        $options = XenForo_Application::get('options');
        if(isset($options->tp_push_key) && !empty($options->tp_push_key))
        {
            $boardurl = XenForo_Application::get('options')->boardUrl;
            $boardurl = urlencode($boardurl);
            if(!class_exists('TapatalkPush'))
            {
                $tapatalk_dir_name = XenForo_Application::get('options')->tp_directory;
                if (empty($tapatalk_dir_name)) $tapatalk_dir_name = 'mobiquo';
                $tapatalk_dir_name = XenForo_Application::getInstance()->getRootDir() . '/' . $tapatalk_dir_name;
                include_once($tapatalk_dir_name . '/push/TapatalkPush.php');
            }
            $TapatalkPush = new TapatalkPush($options->tp_push_key, $boardurl);
            $TapatalkPush->doPushDelete($action, $ids);
        }
    }
    public static function doPushConv($action)
    {
        if(!isset($GLOBALS['tapatalk_conversation_id'])) {
            return;
        }

        $conversationModel = XenForo_Model::create('XenForo_Model_Conversation');
        $conver_msg = $conversationModel->getConversationMasterById($GLOBALS['tapatalk_conversation_id']);
        $conver_msg['action'] = $action;
        $participated_members = $conversationModel->getConversationRecipients($GLOBALS['tapatalk_conversation_id']);

        $recepients = array();
        $visitor = XenForo_Visitor::getInstance();
        $current_user = $visitor->toArray();
        $conver_msg['conv_sender_id'] = isset($current_user['user_id']) && !empty($current_user['user_id']) ? $current_user['user_id'] : $conver_msg['last_message_user_id'];
        $conver_msg['conv_sender_name'] = isset($current_user['username']) && !empty($current_user['username']) ? $current_user['username'] : $conver_msg['last_message_username'];
        foreach($participated_members as $mem_id => $member)
        {
            if($mem_id == $conver_msg['conv_sender_id']) continue;
            if($member['recipient_state'] != 'active') continue;
            $recepients[] = $mem_id;
        }
        $conver_msg['recepients'] = $recepients;
        $options = XenForo_Application::get('options');
        if(isset($options->tp_push_key) && !empty($options->tp_push_key))
            $ttp_data['key'] = $options->tp_push_key;
        if(isset($options->tp_push_key) && !empty($options->tp_push_key))
        {
            $boardurl = XenForo_Application::get('options')->boardUrl;
            $boardurl = urlencode($boardurl);
            if(!class_exists('TapatalkPush'))
            {
                $tapatalk_dir_name = XenForo_Application::get('options')->tp_directory;
                if (empty($tapatalk_dir_name)) $tapatalk_dir_name = 'mobiquo';
                $tapatalk_dir_name = XenForo_Application::getInstance()->getRootDir() . '/' . $tapatalk_dir_name;
                include_once($tapatalk_dir_name . '/push/TapatalkPush.php');
            }
            $TapatalkPush = new TapatalkPush($options->tp_push_key, $boardurl);
            $TapatalkPush->doPushConv($conver_msg, $participated_members);
        }
    }

    public static function doPushConvInvite($action, $invited_user_ids)
    {
        if(!isset($GLOBALS['tapatalk_conversation_id'])) {
            return;
        }

        $conversationModel = XenForo_Model::create('XenForo_Model_Conversation');
        $conver_msg = $conversationModel->getConversationMasterById($GLOBALS['tapatalk_conversation_id']);
        $conver_msg['action'] = $action;
        $participated_members = $conversationModel->getConversationRecipients($GLOBALS['tapatalk_conversation_id']);

        $recepients = array();
        $visitor = XenForo_Visitor::getInstance();
        $current_user = $visitor->toArray();
        $conver_msg['conv_sender_id'] = isset($current_user['user_id']) && !empty($current_user['user_id']) ? $current_user['user_id'] : $conver_msg['last_message_user_id'];
        $conver_msg['conv_sender_name'] = isset($current_user['username']) && !empty($current_user['username']) ? $current_user['username'] : $conver_msg['last_message_username'];
        foreach($participated_members as $mem_id => $member)
        {
            if($mem_id == $conver_msg['conv_sender_id']) continue;
            if($member['recipient_state'] != 'active') continue;
            $recepients[] = $mem_id;
        }
        $conver_msg['recepients'] = $recepients;
        $options = XenForo_Application::get('options');
        if(isset($options->tp_push_key) && !empty($options->tp_push_key))
            $ttp_data['key'] = $options->tp_push_key;
        if(isset($options->tp_push_key) && !empty($options->tp_push_key))
        {
            $boardurl = XenForo_Application::get('options')->boardUrl;
            $boardurl = urlencode($boardurl);
            if(!class_exists('TapatalkPush'))
            {
                $tapatalk_dir_name = XenForo_Application::get('options')->tp_directory;
                if (empty($tapatalk_dir_name)) $tapatalk_dir_name = 'mobiquo';
                $tapatalk_dir_name = XenForo_Application::getInstance()->getRootDir() . '/' . $tapatalk_dir_name;
                include_once($tapatalk_dir_name . '/push/TapatalkPush.php');
            }
            $TapatalkPush = new TapatalkPush($options->tp_push_key, $boardurl);
            $TapatalkPush->doPushConvInvite($conver_msg, $invited_user_ids);
        }
    }
}
