<?php

class Tac_StopHumanSpam_Model_StopHumanSpam extends XenForo_Model
{
	public function getLogById($id)
	{
		return $this->_getDb()->fetchRow('
			SELECT log.*
			FROM sf_stophumanspam_log AS log
			WHERE log.log_id = ?
		', $id);
	}

	
	
	public function meetsMinConditions(array $fetchOptions = array())
	{
		// no need for an extra query,  just use the visitor instance		
		if ( 
		 $fetchOptions['message_count'] >= $fetchOptions['min_posts'] &&
		 $fetchOptions['like_count'] >= $fetchOptions['min_likes'] &&
		 $fetchOptions['days_registered'] >= $fetchOptions['min_reg_days'] &&
		 $fetchOptions['like_post_ratio'] >= $fetchOptions['min_like_post_ratio']		
		)
		{
			return true;	
		}
		
		return false;
	
	}
	
	
	public function contentHasPhoneNumber($message)
	{	
		// not added to core functionality (but pepole can make use of this if they want to customise their add-on)
		$perms = $this->_getSHSPermsModel()->getPermissions();
		if($perms['canBypassPhoneNumberRules'])
		{
			return false;
		}
		
		
		// check for [num]x[num]x[num] 6 or more numbers concatonated by anything other than letters 
		// 07875007195 should match
		// 07875 007195 should match
		// 07875 - 007195 should match
		// 07875m007195 should not match
		// x07875007y should not match
		
		$message = 'zstart '.$message.' ztend'; // added this so we easily know we're at the end
			
		// remove bbtags first, since some bbtags look like this: [COLOR=#000000]
		$message = $this->removeImgAndMedia($message);
		$message = $this->stripOutBBTags($message);
		$message = $this->stripOutOddities($message);
		
		
		
		$options = XenForo_Application::get('options');	
		if($options->allowInternalLinks)
		{
			$message = $this->removeInternalLinks($message);
		}
		
		$message = preg_replace('/[^0-9][1-9][0-9][0-9][0-9][^0-9]/i', '', $message); // years are going to cause an issue, for instance 1977 - 2013 
		// so first remove exact matches for <not num>[1-9][0-9][0-9][0-9]<not num> (basically, 4 numbers in a row with a space
		// this does allows users to sneak phone numbers in like: 1787 5107 195 (but the phone numbers can not start with 0... which alsmost all of them do
		
		
		preg_match('/(?<=[^a-z$\pL])[0-9]([^a-z$\pL]*?)[0-9]([^a-z$\pL]*?)[0-9]([^a-z$\pL]*?)[0-9]([^a-z$\pL]*?)[0-9]([^a-z$\pL]*?)[0-9]([^a-z$\pL])/i', $message, $matches);
		
		
		if($matches)
		{
			return $matches['0'];	
		}		
		return false;
	
	}	
	
	
	
	public function contentHasBBUrls($message)
	{
		$options = XenForo_Application::get('options');	
		if($options->allowInternalLinks)
		{
			$message = $this->removeInternalLinks($message);
			;
		}
				
		// check for [url=..[/url]     '#\[url(.+)\[\/url\]#iUs' 
	
		preg_match('#\[url([\S\s].*?)\[/url\]#i', $message, $matches);
		if($matches)
		{
			return $matches['0'];	
		}		
		return false;
	
	}

	
	public function contentHasBBEmails($message)
	{
			
		$message = $this->removeInternalLinks($message);	
		preg_match('#\[email([\S\s].*?)\[/email\]#i', $message, $matches);
		if($matches)
		{
			return $matches['0'];	
		}		
		return false;
	
	}
	
	
	
	public function contentHasRealUrls($message)
	{
		$options = XenForo_Application::get('options');	
		if($options->allowInternalLinks)
		{
			$message = $this->removeInternalLinks($message);
		}	
		preg_match('/www\.([^a-z]*?)/i', $message, $matches);
		if($matches)
		{
			return $matches['0'];	
		}		
		return false;
	
	}
	
	
	
	public function removeImgAndMedia($message)
	{
		// this removes the tags and the content within the tags
		// [IMG] [/IMG]
		// [MEDIA [/MEDIA]		
		$patterns = array('#\[img([^\[]*?)\[/img\]#i', '#\[media([^\[]*?)\[/media\]#i');
 		return preg_replace($patterns, '', $message);

	}
	
	// strange this not relavant to other sites
	public function stripOutOddities($message)
	{
		
		
		$patterns = array(
			'#0011\+00#i',  // ll plus gets turrned into this in the tags
			'#001100#i',
			'#00100#i', '#00200#i', '#00300#i', '#00400#i', '#00500#i', '#00600#i', '#00700#i', '#00800#i',  '#00900#i', '#00000#i',// key stage 1, 2 etc
			'#:00#i', '#.00#i', '#: 00#i', 	'#. 00#i', // also strip out things that looklike a time frame 11:00 - 12:30
			'#:30#i', '#.30#i',	'#: 30#i', 	'#. 30#i',
			'#:15#i', '#.15#i', '#: 15#i', 	'#. 15#i',
			'#:45#i', '#.45#i', '#: 45#i', 	'#. 45#i',						
		);
		return preg_replace($patterns, '', $message);
	}
	
	public function stripOutBBTags($message)
	{
		// this just removes the tags, not the content within the tags

		$patterns = array(
			'#\[COLOR([^\]]*?)\]#i', 	'#\[/COLOR\]#i', // [COLOR=#000000] & [COLOR]
			'#\[FONT([^\]]*?)\]#i', 	'#\[/FONT\]#i',
			'#\[SIZE([^\]]*?)\]#i', 	'#\[/SIZE\]#i',
			'#\[URL([^\]]*?)\]#i', 		'#\[/URL\]#i',
			'#\[EMAIL([^\]]*?)\]#i', 	'#\[/EMAIL\]#i',
			'#\[IMG([^\]]*?)\]#i', 		'#\[/IMG\]#i',						
			'#\[MEDIA([^\]]*?)\]#i', 	'#\[/MEDIA\]#i',
			'#\[LIST([^\]]*?)\]#i', 	'#\[/LIST\]#i',
			'#\[FONT([^\]]*?)\]#i', 	'#\[/FONT\]#i',
			'#\[I([^\]]*?)\]#i', 		'#\[/I\]#i',
			'#\[U([^\]]*?)\]#i', 		'#\[/U\]#i',
			'#\[S([^\]]*?)\]#i', 		'#\[/S\]#i',	
			'#\[B([^\]]*?)\]#i', 		'#\[/B\]#i',
			);
		return preg_replace($patterns, '', $message);

	}
	
	public function removeInternalLinks($message)
	{
		// these could be bb links, or real links
		$HTTP_HOST = $_SERVER['HTTP_HOST'];
	
		//[URL='http://localhost']
		//[url="http://www.localhost"]www.localhost[/url]"
			
		$patterns = array(
			
		// remove end slashed version first
			"#\[url]http://www.".$HTTP_HOST.'([\S\s].*?)\]#i',  // leave the ebedded link, since the might try: [url]http://www.local.com[/url]'
			"#\[url]https://www.".$HTTP_HOST.'([\S\s].*?)\]#i',
			"#\[url]http://".$HTTP_HOST.'([\S\s].*?)\]#i', 
			"#\[url]https://".$HTTP_HOST.'([\S\s].*?)\]#i',	
			"#\[url]".$HTTP_HOST.'([\S\s].*?)\]#i',
		
			"#\[url='http://www.".$HTTP_HOST.'([\S\s].*?)\]#i',  // leave the ebedded link, since the might try: [url='http://www.local']visting www.fakesite.com[/url]'
			"#\[url='https://www.".$HTTP_HOST.'([\S\s].*?)\]#i',
			"#\[url='http://".$HTTP_HOST.'([\S\s].*?)\]#i', 
			"#\[url='https://".$HTTP_HOST.'([\S\s].*?)\]#i',	
			"#\[url='".$HTTP_HOST.'([\S\s].*?)\]#i',

			'#\[url="http://www.'.$HTTP_HOST.'([\S\s].*?)\]#i',  // double quotes
			'#\[url="https://www.'.$HTTP_HOST.'([\S\s].*?)\]#i',	
			'#\[url="http://'.$HTTP_HOST.'([\S\s].*?)\]#i', 
			'#\[url="https://'.$HTTP_HOST.'([\S\s].*?)\]#i',	
			'#\[url="'.$HTTP_HOST.'/([\S\s].*?)\]#i',		

			"#http://www.".$HTTP_HOST."#i",
			"#https://www.".$HTTP_HOST."#i",											
			"#http://".$HTTP_HOST."#i",
			"#https://".$HTTP_HOST."#i",			
			
			"#http://www.".$HTTP_HOST."#i",
			"#https://www.".$HTTP_HOST."#i",											
			"#http://".$HTTP_HOST."#i",
			"#https://".$HTTP_HOST."#i",

			
			"#www.".$HTTP_HOST."#i",
			"#".$HTTP_HOST."#i", // needs to be done last.. .otherwise you would have remaiders: [URL='http://']
						
			);


		
		return preg_replace($patterns, '', $message);
		
		//return $message;
	}
	
	public function contentHasRealEmails($message)
	{		
		preg_match('/^[a-z0-9_.+-]+[@|at][a-z0-9-]+\.[a-z0-9-.]+$/i', $message, $matches);
		if($matches)
		{
			return $matches['0'];	
		}	
		
		
		// some users really want to add emails, so they will try something like
		// myemail@bla.comm or a variation
		// so detect @hotmail | @live | at hotmail | [at]hotmail | @ h o t m a i l | (etc)

		$commonEmails = array(
			'aol', 'yandex', 'mail', 'hotmail', 'gmail', 'yahoo', 'live', 'outlook'	
		);
		
		foreach($commonEmails as $str)
		{
			$strlen = strlen($str);
			$anyLetter = '([^a-z\pL]*?)'; // any letter for international languages, so @hopmail is fine
			$regexString = $anyLetter;
			
			for( $i = 0; $i < $strlen; $i++ ) 
			{ 
				
	    		$char = substr( $str, $i, 1 );
	    		if($i != $strlen - 1)
	    		{
	    			$regexString = $regexString.$char.$anyLetter;
    			}
				else
				{
					$regexString = $regexString.$char;	
				}
    			
			}
			$regexString = str_replace('o', '(o|0)', $regexString);		
			preg_match('/(@|at|a t)'.$regexString.'/i', $message, $matches); // stops "[any]@[any]live[any].[any]com[any]" @live.com			
			if($matches){return $matches['0'];}
		
				
		}
		

		
		

			
			
			
		return false;
	
	}	

	
	public function contentHasBannedWords($message, $bannedWords = '')
	{
		$message = 'ztstart '.$message.' ztend';
		
		if(!$message || !$bannedWords)
		{
			return false;
		}
		
		$bWords = array_map('trim', explode(",", $bannedWords));
		
		foreach($bWords as $bWord)
		{
			
			if($bWord)
			{
				

				
				if((substr($bWord, 0, 1) == '*') && (substr($bWord, -1) == '*')) //if it starts and ends with a *
				{
					$bWord = str_replace('*', '', $bWord);
					
					preg_match("/(.*)".preg_quote($bWord)."(.*)/i", $message, $matches);
					if($matches)
					{
						return $bWord;
					}
				}
				
				
								
				if(substr($bWord, 0, 1) == '*') //if it starts with a *
				{
					$bWord = str_replace('*', '', $bWord);
					
					preg_match("/(.*)".preg_quote($bWord)."\b/i", $message, $matches);
					if($matches)
					{
						return $bWord;
					}
				}
				
				if(substr($bWord, -1) == '*') //if it ends with a *
				{
					$bWord = str_replace('*', '', $bWord);
					preg_match("/\b".preg_quote($bWord)."(.*)/i", $message, $matches);
					if($matches)
					{
						return $bWord;	
					}
				}				
				
				
				
				if(substr($bWord, 0, 1) != '*')	
				{
					preg_match("/\b" . preg_quote($bWord) . "\b/i", $message, $matches);
					if($matches)
					{
						return $bWord;
					}
				}	
			}
			
		}
		
		return false;
	}
	
	public function contentHasRandomTypedCharacters($message)
	{
		
		
		// remove bbtags first, and urls, since some urls are long
		$message = $this->removeImgAndMedia($message);
		$message = $this->stripOutBBTags($message);
		// $message = $this->stripOutURLs($message);
		
		
		preg_match('/ewqewq/i', $message, $m1);
		preg_match('/rewrew/i', $message, $m2);
		preg_match('/dsadsa/i', $message, $m3);
		preg_match('/fdsfds/i', $message, $m4);
		preg_match('/(\w)\1{5,}/i', $message, $m5); // checks for charaters repeated 5 times
		preg_match('/\w{35,}\b/i', $message, $m6);	//	\w{1,10}\b	// if a word is longer than 25 characters it's very likely to be random typing
		if($m1){return $m1;}
		if($m2){return $m2;}
		if($m3){return $m3;}
		if($m4){return $m4;}
		if($m5){return $m5;}	
		if($m6){return $m6;}	
		
		return false;
	}
	
	public function contentHasSneakyUrl($message)
	{
		$message = 'ztstart '.$message.' ztend'; // added this so we easily know we're at the end

		$options = XenForo_Application::get('options');	
		if($options->allowInternalLinks)
		{
			$message = $this->removeInternalLinks($message);
		}		
				
		preg_match('/(?<=[^a-z\pL])w([^a-z\pL]*?)w([^a-z\pL]*?)w([^a-z\pL])/i', $message, $m1); // w w w, if we have letter in between the w w w, then it's really skewed enough wzwzwz.mysite.czozm is just silly, we also should not detect awww
		preg_match('/dub([^a-z\pL]*?)dub([^a-z\pL]*?)dub([^a-z\pL])/i', $message, $m2);
		preg_match('/dublu([^a-z\pL]*?)dublu([^a-z\pL]*?)dublu([^a-z\pL])/i', $message, $m3);
		preg_match('/(?<=[^a-z\pL])uu([^a-z\pL]*?)uu([^a-z\pL]*?)uu([^a-z\pL])/i', $message, $m4); // stretched words "youuuuuuuuuuuuuu" shouldn't be detected
			
		preg_match('/h([^a-z\pL]*?)t([^a-z\pL]*?)t([^a-z\pL]*?)p([^a-z\pL])/i', $message, $m5); // h t t p
	
		preg_match('/(\.|dot)([^a-z\pL]*?)c([^a-z\pL]*?)(o|0||||||)([^a-z\pL]*?)m([^a-z\pL])/i', $message, $m6); // . c o m, but what about: "Hi. Comment on my post" (after com[ifLetterNotSneakyURL]
		preg_match('/(\.|dot)([^a-z\pL]*)(o|0||||||)([^a-z\pL]*)r([^a-z\pL]*)g([^a-z\pL])/i', $message, $m7); // . o r g
		preg_match('/(\.|dot)n([^a-z\pL]*?)e([^a-z\pL]*?)t([^a-z\pL])/i', $message, $m8);// .n e t (can't do ". n e t", since a sentance could start with ". Net")
		preg_match('/(\.|dot)([^a-z\pL]*?)b([^a-z\pL]*?)i([^a-z\pL]*?)z([^a-z\pL])/i', $message, $m9); // . b i z
		preg_match('/(\.|dot)([^a-z\pL]*?)i([^a-z\pL]*?)n([^a-z\pL]*?)f([^a-z\pL]*?)(o|0||||||)([^a-z\pL])/i', $message, $m10); // . i n f o
		preg_match('/(\.|dot)([^a-z\pL]*?)c([^a-z\pL]*?)(o|0||||||)([^a-z\pL]*?).([^a-z\pL]*?)u([^a-z\pL]*?)k([^a-z\pL])/i', $message, $m11); // . c o . u k
		
		
		if($m1){return 'www';}
		if($m2){return 'www';}
		if($m3){return 'www';}
		if($m4){return 'www';}
		if($m5){return 'http';}
		if($m6){return '.com';}
		if($m7){return '.org';}
		if($m8){return '.net';}
		if($m9){return '.biz';}
		if($m10){return '.info';}
		if($m11){return '.co.uk';}
		
		return false;	
	}
	
	
	public function getcondFetchOpts($options)
	{
		
		$visitor = XenForo_Visitor::getInstance();		
		$message_count = $visitor->get('message_count');
		$like_count = $visitor->get('like_count');
		$register_date = $visitor->get('register_date');
		$like_post_ratio = round($like_count && $message_count? ($like_count/$message_count)*100: 0);
     	$days_registered = floor((time() - $register_date)/(60*60*24));
		
		return array
		(
			'min_posts' => $options->shsMinPostLink,
			'min_likes' => $options->shsMinLikes,
			'min_reg_days' => $options->shsMinRegDays,
			'min_like_post_ratio' => $options->shsMinLikePostRatio,
			'min_posts_m1' => $options->shsMinPostLink -1,
			'min_likes_m1' => $options->shsMinLikes -1,
			'min_reg_days_m1' => $options->shsMinRegDays -1,
			'min_like_post_ratio_m1' => $options->shsMinLikePostRatio -1,
			'message_count' => $message_count,
			'like_count' => $like_count,
			'days_registered' => $days_registered,
			'like_post_ratio' => $like_post_ratio,		
		);	
	}
	
	public function getModSigCond($options)
	{
		
		$visitor = XenForo_Visitor::getInstance();		
		$message_count = $visitor->get('message_count');
		$like_count = $visitor->get('like_count');
		$register_date = $visitor->get('register_date');
		$like_post_ratio = round($like_count && $message_count? ($like_count/$message_count)*100: 0);
     	$days_registered = floor((time() - $register_date)/(60*60*24));
		
		return array
		(
			'min_posts' => $options->shsMinPostModSig,
			'min_likes' => $options->shsMinLikesModSig,
			'min_reg_days' => $options->shsMinRegDaysModSig,
			'min_like_post_ratio' => $options->shsMinLikePostRatioModSig,
			'min_posts_m1' => $options->shsMinPostModSig -1,
			'min_likes_m1' => $options->shsMinLikesModSig -1,
			'min_reg_days_m1' => $options->shsMinRegDaysModSig -1,
			'min_like_post_ratio_m1' => $options->shsMinLikePostRatioModSig -1,
			'message_count' => $message_count,
			'like_count' => $like_count,
			'days_registered' => $days_registered,
			'like_post_ratio' => $like_post_ratio,		
		);	
	}	
	
	
	public function getMsgReplaceVars()
	{		

		return array
		(
			'{min_posts_m1}', 
			'{min_likes_m1}', 
			'{min_regdays_m1}',
			'{min_like_post_ratio_m1}',
			'{min_posts}', 
			'{min_likes}', 
			'{min_regdays}',
			'{min_like_post_ratio}',
			'{message_count}',
			'{like_count}',
			'{days_registered}',
			'{like_post_ratio}'			
		);
	
	}

	
	public function getMsgReplaceVals($condFetchOpts)
	{		

		return array
		(
			$condFetchOpts['min_posts']-1,
			$condFetchOpts['min_likes']-1,
			$condFetchOpts['min_reg_days']-1,
			$condFetchOpts['min_like_post_ratio']-1,
			$condFetchOpts['min_posts'],
			$condFetchOpts['min_likes'],
			$condFetchOpts['min_reg_days'], 
			$condFetchOpts['min_like_post_ratio'],
			$condFetchOpts['message_count'],
			$condFetchOpts['like_count'],
			$condFetchOpts['days_registered'],
			$condFetchOpts['like_post_ratio']
		);
	}

		
	public function logEvent($errorMsg, $content, $location = '')
	{
		$options = XenForo_Application::get('options');	
		if($options->shsLogEvents)
		{	
			$visitor = XenForo_Visitor::getInstance();		
			$logWriter = XenForo_DataWriter::create('Tac_StopHumanSpam_DataWriter_Log');
			//$logWriter->setExistingData($log_id);	
			//$logWriter->bulkSet();
			$logWriter->set('log_date', XenForo_Application::$time);
			$logWriter->set('user_id', $visitor->get('user_id'));
			$logWriter->set('username', $visitor->get('username'));
			$logWriter->set('error_msg', $errorMsg);
			$logWriter->set('content', $content);
			$logWriter->set('location', $location);
			$logWriter->save();				
		}
	}
	
	
	
	public function _updatePostsMessageState(array $posts, array $threads, array $forums, $newState, $expectedOldState = false)
	{
		switch ($newState)
		{
			case 'visible':
				switch (strval($expectedOldState))
				{
					case 'visible': return;
					case 'moderated': $logAction = 'approve'; break;
					case 'deleted': $logAction = 'undelete'; break;
					default: $logAction = 'undelete'; break;
				}
				break;

			case 'moderated':
				switch (strval($expectedOldState))
				{
					case 'visible': $logAction = 'unapprove'; break;
					case 'moderated': return;
					case 'deleted': $logAction = 'unapprove'; break;
					default: $logAction = 'unapprove'; break;
				}
				break;

			case 'deleted':
				switch (strval($expectedOldState))
				{
					case 'visible': $logAction = 'delete_soft'; break;
					case 'moderated': $logAction = 'delete_soft'; break;
					case 'deleted': return;
					default: $logAction = 'delete_soft'; break;
				}
				break;

			default: return;
		}

		foreach ($posts AS $post)
		{
			list($thread, $forum) = $this->_getThreadAndForumFromPost($post, $threads, $forums);

			if ($post['post_id'] == $thread['first_post_id'])
			{
				$dw = XenForo_DataWriter::create('XenForo_DataWriter_Discussion_Thread', XenForo_DataWriter::ERROR_SILENT);
				$dw->setExistingData($thread);

				if ($expectedOldState && $dw->get('discussion_state') != $expectedOldState)
				{
					continue;
				}

				$dw->set('discussion_state', $newState);
				$dw->setExtraData(XenForo_DataWriter_Discussion_Thread::DATA_FORUM, $forum);
				$dw->save();

				if ($this->enableLogging)
				{
					XenForo_Model_Log::logModeratorAction('thread', $thread, $logAction);
				}
			}
			else
			{
				if ($expectedOldState && $post['message_state'] != $expectedOldState)
				{
					continue;
				}

				$dw = XenForo_DataWriter::create('XenForo_DataWriter_DiscussionMessage_Post', XenForo_DataWriter::ERROR_SILENT);
				$dw->setExistingData($post);
				$dw->set('message_state', $newState);
				$dw->setExtraData(XenForo_DataWriter_DiscussionMessage_Post::DATA_FORUM, $forum);
				$dw->save();

				//if ($this->enableLogging)
				{
					XenForo_Model_Log::logModeratorAction('post', $post, $logAction, array(), $thread);
				}
			}
		}
	}
	

	
	
	
	
	public function _updateThreadsDiscussionState(array $threads, array $forums, $newState, $expectedOldState = false)
	{
		switch ($newState)
		{
			case 'visible':
				switch (strval($expectedOldState))
				{
					case 'visible': return;
					case 'moderated': $logAction = 'approve'; break;
					case 'deleted': $logAction = 'undelete'; break;
					default: $logAction = 'undelete'; break;
				}
				break;

			case 'moderated':
				switch (strval($expectedOldState))
				{
					case 'visible': $logAction = 'unapprove'; break;
					case 'moderated': return;
					case 'deleted': $logAction = 'unapprove'; break;
					default: $logAction = 'unapprove'; break;
				}
				break;

			case 'deleted':
				switch (strval($expectedOldState))
				{
					case 'visible': $logAction = 'delete_soft'; break;
					case 'moderated': $logAction = 'delete_soft'; break;
					case 'deleted': return;
					default: $logAction = 'delete_soft'; break;
				}
				break;

			default: return;
		}

		foreach ($threads AS $thread)
		{
			if ($expectedOldState && $thread['discussion_state'] != $expectedOldState)
			{
				continue;
			}

			$dw = XenForo_DataWriter::create('XenForo_DataWriter_Discussion_Thread', XenForo_DataWriter::ERROR_SILENT);
			$dw->setExistingData($thread);
			$dw->set('discussion_state', $newState);

			if (array_key_exists($dw->get('node_id'), $forums))
			{
				$dw->setExtraData(XenForo_DataWriter_Discussion_Thread::DATA_FORUM, $forums[$dw->get('node_id')]);
			}

			$dw->save();

			//if ($this->enableLogging)
			{
				XenForo_Model_Log::logModeratorAction('thread', $thread, $logAction);
			}
		}
	}	
	
	
	
	
	
	
	
	
	
	protected function _getThreadAndForumFromPost(array $post, array $threads, array $forums)
	{
		$thread = $threads[$post['thread_id']];
		$forum = $forums[$thread['node_id']];

		return array($thread, $forum);
	}
	
	
	protected function _getSHSPermsModel()
	{
		return $this->getModelFromCache('Tac_StopHumanSpam_Model_Perms');
	}			
	
}