<?php

class Tac_StopHumanSpam_Model_Log extends XenForo_Model
{
	public function getLogById($id)
	{
		return $this->_getDb()->fetchRow('
			SELECT log.*
			FROM sf_stophumanspam_log AS log
			WHERE log.log_id = ?
		', $id);
	}

	
	
	public function getLogByUsername($username)
	{
		return $this->_getDb()->fetchRow('
			SELECT log.*
			FROM sf_stophumanspam_log AS log
			WHERE log.username = ?
		', $username);
	}
		
	
	
	public function getLogs(array $fetchOptions = array())
	{
		$whereCondition = "";
		$limitOptions = $this->prepareLimitFetchOptions($fetchOptions);
		if(array_key_exists('username', $fetchOptions))
		{
			$whereCondition = ($fetchOptions['username'] ? ' WHERE username LIKE "%'.$fetchOptions['username'].'%"' : '');
		}
			
		if(array_key_exists('email', $fetchOptions) && $fetchOptions['email'])
		{
			if(!$whereCondition)
			{
				$whereCondition = ' WHERE email LIKE "%'.$fetchOptions['email'].'%"';
			}
			else
			{
				$whereCondition += ' AND email LIKE "%'.$fetchOptions['email'].'%"';
			}
	    }
	   
	    
	    if (array_key_exists('filter', $fetchOptions) && $fetchOptions['filter'] && !$whereCondition) 
		{
			switch ($fetchOptions['filter']) 
			{
				case 'no_filter':
					$whereCondition = '';
				    break;
				case 'javascript_enabled':
					$whereCondition = ' WHERE javascript_enabled = 1';
				    break;
				case 'javascript_disabled':
					$whereCondition = ' WHERE javascript_enabled = 0';
					break;
				case 'altered_hidden_fields':
					$whereCondition = ' WHERE altered_hidden_fields != "b:0;"';
					break;
				case 'no_altered_hidden_fields':
					$whereCondition = ' WHERE altered_hidden_fields = "b:0;"';
					break;
				case 'registration_time_less_than_30s':
					$whereCondition = ' WHERE registration_time < 30';
					break;
				case 'registration_time_more_than_30s':
					$whereCondition = ' WHERE registration_time > 30';
					break;
			}
		}	
		else if (array_key_exists('filter', $fetchOptions) && $fetchOptions['filter'] && $whereCondition) 
		{
			switch ($fetchOptions['filter']) 
			{
				case 'no_filter':
					$whereCondition += '';
				    break;
				case 'javascript_enabled':
					$whereCondition += ' AND javascript_enabled = 1';
				    break;
				case 'javascript_disabled':
					$whereCondition += ' AND javascript_enabled = 0';
					break;
				case 'altered_hidden_fields':
					$whereCondition = ' AND altered_hidden_fields != "b:0;"';
					break;
				case 'no_altered_hidden_fields':
					$whereCondition = ' AND altered_hidden_fields = "b:0;"';
					break;
				case 'registration_time_less_than_30s':
					$whereCondition = ' AND registration_time < 30';
					break;
				case 'registration_time_more_than_30s':
					$whereCondition = ' AND registration_time > 30';
					break;
			}
		}
	    
	    
	    
	    
		return $this->fetchAllKeyed($this->limitQueryResults(
			'
				SELECT *
				FROM sf_stophumanspam_log
				'.$whereCondition.'
				ORDER BY log_date DESC
				
			', $limitOptions['limit'], $limitOptions['offset']
		), ';log_id');
	}
	
	
	
	
	

	

	public function countLogs($username = NULL, $email = NULL, $filter = NULL)
	{
		$whereCondition = ($username ? ' WHERE username LIKE "%'.$username.'%"' : '');
		
		if($email) 
		{
			if(!$whereCondition)
			{
				$whereCondition = ' WHERE email LIKE "%'.$email.'%"';
			}
			else
			{
				$whereCondition += ' AND email LIKE "%'.$email.'%"';
			}
		}		

		
				
		if($filter && !$whereCondition) 
		{
			switch ($filter) 
			{
				case 'no_filter':
					$whereCondition = '';
				    break;
				case 'javascript_enabled':
					$whereCondition = ' WHERE javascript_enabled = 1';
				    break;
				case 'javascript_disabled':
					$whereCondition = ' WHERE javascript_enabled = 0';
					break;
				case 'altered_hidden_fields':
					$whereCondition = ' WHERE altered_hidden_fields != "b:0;"';
					break;
				case 'no_altered_hidden_fields':
					$whereCondition = ' WHERE altered_hidden_fields = "b:0;"';
					break;
				case 'registration_time_less_than_30s':
					$whereCondition = ' WHERE registration_time < 30';
					break;
				case 'registration_time_more_than_30s':
					$whereCondition = ' WHERE registration_time > 30';
					break;
			}
		}			
		else if ($filter && $whereCondition) 
		{
			switch ($filter) 
			{
				case 'no_filter':
					$whereCondition += '';
				    break;
				case 'javascript_enabled':
					$whereCondition += ' AND javascript_enabled = 1';
				    break;
				case 'javascript_disabled':
					$whereCondition += ' AND javascript_enabled = 0';
					break;
				case 'altered_hidden_fields':
					$whereCondition += ' AND altered_hidden_fields != "b:0;"';
					break;
				case 'no_altered_hidden_fields':
					$whereCondition += ' AND altered_hidden_fields = "b:0;"';
					break;
				case 'registration_time_less_than_30s':
					$whereCondition += ' AND registration_time < 30';
					break;
				case 'registration_time_more_than_30s':
					$whereCondition += ' AND registration_time > 30';
					break;
			}
		}
		
		
		return $this->_getDb()->fetchOne('
			SELECT COUNT(*)
			FROM sf_stophumanspam_log
			'.$whereCondition.'
		');
	}

	public function deleteLog($id)
	{
		$db = $this->_getDb();
		$db->delete('sf_stophumanspam_log', 'log_id = ' . $db->quote($id));
	}

	public function clearLog()
	{
		$this->_getDb()->query('TRUNCATE TABLE sf_stophumanspam_log');
	}	
	
	
	
	public function convertIpToLong($ipAddress = null)
	{
		if ($ipAddress === null)
		{
			$ipAddress = (isset($_SERVER['REMOTE_ADDR']) ? $_SERVER['REMOTE_ADDR'] : 0);
		}

		if (is_string($ipAddress) && strpos($ipAddress, '.'))
		{
			$ipAddress = ip2long($ipAddress);
		}

		return sprintf('%u', $ipAddress);
	}



}