<?php

/**
* DataWriter for the ListingClaim: 
* @package XenForo_Node
*/
class Tac_StopHumanSpam_DataWriter_Log extends XenForo_DataWriter
{

	protected function _getFields()
	{
		return array(
			'sf_stophumanspam_log' => array(	
				'log_id'        	  		=> array('type' => self::TYPE_UINT,   	'autoIncrement' => true, 	'maxLength' => 11),
				'log_date' 					=> array('type' => self::TYPE_UINT,   	'required' => true, 'maxLength' => 10),
				'user_id' 					=> array('type' => self::TYPE_UINT, 	'required' => true),
				'username'  				=> array('type' => self::TYPE_STRING, 	'default' => ''),
				'error_msg'					=> array('type' => self::TYPE_STRING, 	'required' => true),
				'content'					=> array('type' => self::TYPE_STRING, 	'default' => ''),	
				'location'					=> array('type' => self::TYPE_STRING, 	'default' => ''),			
			)
		);
	}

	
	


	protected function _getExistingData($data)
	{
		if (!$log_id = $this->_getExistingPrimaryKey($data, 'log_id'))
		{
			return false;
		}

		return array('sf_stophumanspam_log' => $this->getModelFromCache('Tac_StopHumanSpam_Model_Log')->getLogById($log_id));
	}

	protected function _getUpdateCondition($tableName)	
	{
		return 'log_id = ' . $this->_db->quote($this->getExisting('log_id'));
	}


}