<?php


class Tac_StopHumanSpam_ControllerPublic_Member extends XFCP_Tac_StopHumanSpam_ControllerPublic_Member
{

		
	public function actionPost()
	{	
		$options = XenForo_Application::get('options');	
		$input['message'] = $this->_input->filter(array('message' => XenForo_Input::STRING));
		$input['message'] = XenForo_Helper_String::autoLinkBbCode($input['message']);
		
		$perms = $this->_getSHSPermsModel()->getPermissions();				
		$stopHumanSpamModel = $this->_getStopHumanSpamModel();
		$canPost = true;
		

		$userId = $this->_input->filterSingle('user_id', XenForo_Input::UINT);
		$user = $this->getHelper('UserProfile')->assertUserProfileValidAndViewable($userId);
		$location = XenForo_Link::buildPublicLink('members', $user);
		
		
		
		
		
		
		if(!($options->shsProfilePostOn))
		{
			return parent::actionPost();
		}
		
		// check spam titles, theads should never contain these banned words (even for users that have met like/post requiement for link-post-rules)
		if(!$perms['canBypassStopBannedWords'])
		{
			if($options->shsBannedPostContent && ($bWord = $stopHumanSpamModel->contentHasBannedWords($input['message'], $options->shsBannedPostContentWords)))
			{

				$errorMsg = new XenForo_Phrase('shs_content_contains_banned_words', array('bWord' => $bWord)); 			
				$stopHumanSpamModel->logEvent($errorMsg, $input['message'], $location);
				return $this->responseError($errorMsg);	
			}
		}
		
						
		$condFetchOpts = $stopHumanSpamModel->getcondFetchOpts($options);
		if($stopHumanSpamModel->meetsMinConditions($condFetchOpts)) 
		{	
			return parent::actionPost();	
		}		
	
		

				
		if(!$perms['canBypassLinkPostRules'])
		{		
			if($options->shsPostsOn)
			{
				$contentHasUrl = $stopHumanSpamModel->contentHasBBUrls($input['message']); 
				if($contentHasUrl)
				{
					$canPost = false;	
				}	
			}			
			if($options->shsMailOn)
			{
				$contentHasEmail = $stopHumanSpamModel->contentHasBBEmails($input['message']); 
				if($contentHasEmail)
				{
					$canPost = false;	
				}
			}	
			if(!$canPost)
			{
				$replace = $stopHumanSpamModel->getMsgReplaceVars();
				$replace[] = '{nodeType}';
				$withThis = $stopHumanSpamModel->getMsgReplaceVals($condFetchOpts);
				$withThis[] = 'Profile Post';
				$errorMsg = str_replace($replace, $withThis, $options->shsLinksMessage);								
				$stopHumanSpamModel->logEvent($errorMsg, $input['message'], $location);
				return $this->responseError($errorMsg);		
			}
		}
		
		// sneaky urls are okay for users that have passed meetsMinConditions (so it will never get to here)
		if(!$perms['canBypassStopSneakyUrls']  && ($options->stopSneakyUrlsProfilePostsOn == 1))
		{
			if($sneakContent = $stopHumanSpamModel->contentHasSneakyUrl($input['message']))
			{
				$errorMsg = new XenForo_Phrase('a_sneaky_url_has_been_detected_in_your_content');
				if($options->sneakyUrlExtraInfo)
				{	
					$errorMsg .= ": ".$sneakContent;
				}	
				$stopHumanSpamModel->logEvent($errorMsg, $input['message'], $location);
				return $this->responseError($errorMsg);	
				
			}
		}
		
		return parent::actionPost();						
	}

	
	protected function _getStopHumanSpamModel()
	{
		return $this->getModelFromCache('Tac_StopHumanSpam_Model_StopHumanSpam');
	}

	protected function _getSHSPermsModel()
	{
		return $this->getModelFromCache('Tac_StopHumanSpam_Model_Perms');
	}		
	
	
	
		
}	